/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.internal.rest;

import com.xpn.xwiki.XWikiContext;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.moccacalendar.importJob.ImportJobRequest;
import org.xwiki.contrib.moccacalendar.rest.MoccaCalendarResource;
import org.xwiki.job.Job;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.rest.internal.resources.pages.ModifiablePageResource;
import org.xwiki.stability.Unstable;

@Unstable
@Component
@Named(value="org.xwiki.contrib.moccacalendar.internal.rest.DefaultMoccaCalendarResource")
@Singleton
public class DefaultMoccaCalendarResource
extends ModifiablePageResource
implements MoccaCalendarResource {
    @Inject
    private Logger logger;
    @Inject
    private JobExecutor jobExecutor;

    @Override
    public Response importCalendarFile(String parentCalendar, byte[] file) {
        try {
            XWikiContext wikiContext = (XWikiContext)this.xcontextProvider.get();
            ArrayList<String> jobId = new ArrayList<String>();
            jobId.add("moccacalendar");
            jobId.add("import");
            jobId.add(parentCalendar);
            Job job = this.jobExecutor.getJob(jobId);
            if (job == null) {
                ImportJobRequest importJobRequest = new ImportJobRequest(jobId, file, parentCalendar, wikiContext.getUserReference());
                this.jobExecutor.execute("moccacalendar.import", (Request)importJobRequest);
                return Response.status((int)202).type(MediaType.TEXT_PLAIN_TYPE).build();
            }
            return Response.notModified().type(MediaType.TEXT_PLAIN_TYPE).build();
        }
        catch (Exception e) {
            this.logger.warn("Failed to import .ics file data. Root cause: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

