/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.internal.generators;

import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.moccacalendar.EventInstance;
import org.xwiki.contrib.moccacalendar.internal.generators.AbstractRecurrentEventGenerator;

@Component
@Singleton
@Named(value="monthlySpecific")
public class MonthlySpecificEventGenerator
extends AbstractRecurrentEventGenerator {
    @Override
    protected void incrementCalendarByOnePeriod(Calendar cal, int ... occurrence) {
        int originalDayOfWeek = cal.get(7);
        cal.set(5, 1);
        cal.add(2, 1);
        int nextMonth = cal.get(2);
        int weekdayCount = 0;
        int lastOccurrenceDay = 1;
        while (cal.get(2) == nextMonth) {
            if (cal.get(7) == originalDayOfWeek) {
                lastOccurrenceDay = cal.get(5);
                if (++weekdayCount == occurrence[0]) {
                    return;
                }
            }
            cal.add(5, 1);
        }
        cal.add(5, -1);
        cal.set(5, lastOccurrenceDay);
    }

    @Override
    protected List<EventInstance> createEventInstances(XWikiDocument event, Date startDate, long duration, Date dateFrom, Date dateTo) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        int occurrence = this.getOccurrence(cal);
        while (cal.getTimeInMillis() + duration < dateFrom.getTime()) {
            this.incrementCalendarByOnePeriod(cal, occurrence);
        }
        ArrayList<EventInstance> eventInstances = new ArrayList<EventInstance>();
        while (cal.getTime().compareTo(dateTo) <= 0) {
            EventInstance instance = new EventInstance();
            instance.setStartDate(new DateTime(cal.getTimeInMillis()));
            instance.setEndDate(new DateTime(cal.getTimeInMillis() + duration));
            eventInstances.add(instance);
            if (eventInstances.size() >= 1000) break;
            this.incrementCalendarByOnePeriod(cal, occurrence);
        }
        return eventInstances;
    }

    private int getOccurrence(Calendar cal) {
        int originalDayOfWeek = cal.get(7);
        int originalDay = cal.get(5);
        int originalMonth = cal.get(2);
        Calendar temp = (Calendar)cal.clone();
        temp.set(5, 1);
        int occurrence = 0;
        while (temp.get(2) == originalMonth && temp.get(5) <= originalDay) {
            if (temp.get(7) == originalDayOfWeek) {
                ++occurrence;
            }
            temp.add(5, 1);
        }
        return occurrence;
    }
}

