/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.internal.generators;

import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.moccacalendar.EventInstance;
import org.xwiki.contrib.moccacalendar.internal.generators.AbstractRecurrentEventGenerator;

@Named(value="customWeekly")
@Singleton
@Component
public class CustomWeeklyEventGenerator
extends AbstractRecurrentEventGenerator {
    @Override
    protected void incrementCalendarByOnePeriod(Calendar cal, int ... pos) {
        cal.add(3, 1);
    }

    @Override
    protected List<EventInstance> createEventInstances(XWikiDocument event, Date startDate, long duration, Date dateFrom, Date dateTo) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        cal.set(7, 7);
        while (cal.getTimeInMillis() + duration <= dateFrom.getTime()) {
            this.incrementCalendarByOnePeriod(cal, new int[0]);
        }
        List rawDays = event.getListValue("days");
        List days = rawDays.stream().map(Object::toString).map(Integer::parseInt).sorted().collect(Collectors.toList());
        ArrayList<EventInstance> eventInstances = new ArrayList<EventInstance>();
        while (cal.getTime().compareTo(dateTo) <= 0) {
            Iterator iterator = days.iterator();
            while (iterator.hasNext()) {
                int day = (Integer)iterator.next();
                cal.set(7, day);
                long recurrenceTime = cal.getTimeInMillis();
                if (recurrenceTime < dateFrom.getTime() || recurrenceTime + duration > dateTo.getTime()) continue;
                EventInstance instance = new EventInstance();
                instance.setStartDate(new DateTime(recurrenceTime));
                instance.setEndDate(new DateTime(recurrenceTime + duration));
                eventInstances.add(instance);
            }
            if (eventInstances.size() >= 1000) break;
            cal.set(7, 1);
            this.incrementCalendarByOnePeriod(cal, new int[0]);
        }
        return eventInstances;
    }
}

