/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.internal.generators;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.xwiki.contrib.moccacalendar.EventInstance;
import org.xwiki.contrib.moccacalendar.RecurrentEventGenerator;
import org.xwiki.contrib.moccacalendar.internal.Utils;

public abstract class AbstractRecurrentEventGenerator
implements RecurrentEventGenerator {
    protected static final int MAX_INSTANCES = 1000;
    @Inject
    private Logger logger;

    protected abstract void incrementCalendarByOnePeriod(Calendar var1, int ... var2);

    @Override
    public List<EventInstance> generate(XWikiDocument event, Date dateFrom, Date dateTo) {
        boolean allDay;
        BaseObject eventData = event.getXObject(event.resolveClassReference("MoccaCalendar.MoccaCalendarEventClass"));
        BaseObject eventRecData = event.getXObject(event.resolveClassReference("MoccaCalendar.Code.MoccaCalendarEventRecurrencyClass"));
        Date startDate = eventData.getDateValue("startDate");
        Date endDate = eventData.getDateValue("endDate");
        boolean bl = allDay = eventData.getIntValue("allDay") == 1;
        if (allDay) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(startDate);
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, 0);
            cal.set(11, 0);
            startDate = cal.getTime();
        }
        if (endDate == null) {
            endDate = Utils.guessEndDate(startDate, allDay);
        }
        long duration = endDate.getTime() - startDate.getTime();
        Date firstInstance = eventRecData.getDateValue("firstInstance");
        Date lastInstance = eventRecData.getDateValue("lastInstance");
        Date actualDateFrom = dateFrom;
        if (firstInstance != null && firstInstance.after(dateFrom)) {
            actualDateFrom = firstInstance;
        }
        Date actualDateTo = dateTo;
        if (lastInstance != null && lastInstance.before(dateTo)) {
            actualDateTo = lastInstance;
        }
        if (dateTo.before(actualDateFrom)) {
            return Collections.emptyList();
        }
        return this.createEventInstances(event, startDate, duration, actualDateFrom, actualDateTo);
    }

    protected List<EventInstance> createEventInstances(XWikiDocument event, Date startDate, long duration, Date dateFrom, Date dateTo) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        while (cal.getTimeInMillis() + duration < dateFrom.getTime()) {
            this.incrementCalendarByOnePeriod(cal, new int[0]);
        }
        ArrayList<EventInstance> eventInstances = new ArrayList<EventInstance>();
        while (cal.getTime().compareTo(dateTo) <= 0) {
            EventInstance instance = new EventInstance();
            instance.setStartDate(new DateTime(cal.getTimeInMillis()));
            instance.setEndDate(new DateTime(cal.getTimeInMillis() + duration));
            eventInstances.add(instance);
            if (eventInstances.size() >= 1000) {
                this.logger.info("maximal number of events generated for [{}]; stopping", (Object)event);
                break;
            }
            this.incrementCalendarByOnePeriod(cal, new int[0]);
        }
        return eventInstances;
    }
}

