/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.internal.importJob;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;
import org.xwiki.component.annotation.Component;
import org.xwiki.fullcalendar.model.CalendarEvent;
import org.xwiki.fullcalendar.model.RecurrentEventModification;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.stability.Unstable;
import org.xwiki.wysiwyg.converter.HTMLConverter;

@Unstable
@Component(roles={CalendarEventImporter.class})
@Singleton
public class CalendarEventImporter {
    private static final String NEW_EVENT_HOME = "WebHome";
    @Inject
    private HTMLConverter htmlConverter;
    @Inject
    private Provider<XWikiContext> wikiContextProvider;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> documentReferenceResolver;

    public void importCalendarEvent(XWikiDocument eventDoc, CalendarEvent component) throws XWikiException {
        XWikiContext wikiContext = (XWikiContext)this.wikiContextProvider.get();
        DocumentReference eventClassRef = this.documentReferenceResolver.resolve((Object)"MoccaCalendar.MoccaCalendarEventClass", new Object[0]);
        BaseObject eventObj = eventDoc.newXObject((EntityReference)eventClassRef, wikiContext);
        this.addConvertedPropertyToObject(component.getDescription(), eventObj, "description");
        this.addConvertedPropertyToObject(component.getTitle(), eventObj, "title");
        int allDay = component.isAllDay() ? 1 : 0;
        eventObj.set("allDay", (Object)allDay, wikiContext);
        if (allDay == 1) {
            LocalDateTime end = component.getEnd().toInstant().atZone(ZoneOffset.UTC).toLocalDateTime().minusDays(1L);
            eventObj.set("endDate", (Object)Date.from(end.atZone(ZoneOffset.UTC).toInstant()), wikiContext);
        } else {
            eventObj.set("endDate", (Object)component.getEnd(), wikiContext);
        }
        eventObj.set("startDate", (Object)component.getStart(), wikiContext);
        int recurrenceValue = component.isRecurrent();
        eventObj.set("recurrent", (Object)recurrenceValue, wikiContext);
        if (recurrenceValue == 1) {
            this.setRecurrence(eventDoc, component);
        }
    }

    public XWikiDocument getUniqueEventName(String eventName, String parentRef, List<XWikiDocument> eventDocuments) throws XWikiException {
        XWikiContext wikiContext = (XWikiContext)this.wikiContextProvider.get();
        DocumentReference parentDocRef = this.documentReferenceResolver.resolve((Object)parentRef, new Object[0]);
        SpaceReference documentSpaceRef = new SpaceReference(eventName, parentDocRef.getLastSpaceReference());
        DocumentReference eventRef = new DocumentReference(NEW_EVENT_HOME, documentSpaceRef);
        XWikiDocument eventDoc = wikiContext.getWiki().getDocument(eventRef, wikiContext);
        if (!eventDoc.isNew() || this.sameNameEventExists(eventRef, eventDocuments)) {
            String newEventName = eventName + "_" + System.nanoTime();
            SpaceReference newDocumentSpaceRef = new SpaceReference(newEventName, parentDocRef.getLastSpaceReference());
            DocumentReference newEventRef = new DocumentReference(NEW_EVENT_HOME, newDocumentSpaceRef);
            eventDoc = new XWikiDocument(newEventRef);
        }
        eventDoc.setTitle(eventName);
        eventDoc.setParentReference((EntityReference)parentDocRef);
        return eventDoc;
    }

    private void addConvertedPropertyToObject(String htmlContent, BaseObject eventObj, String property) {
        String cleanHTMLContent = Jsoup.clean((String)htmlContent, (Safelist)Safelist.basic());
        String convertedContent = this.htmlConverter.fromHTML(cleanHTMLContent, Syntax.XWIKI_2_1.toIdString());
        eventObj.set(property, (Object)convertedContent, (XWikiContext)this.wikiContextProvider.get());
    }

    private void setRecurrence(XWikiDocument eventDoc, CalendarEvent component) throws XWikiException {
        XWikiContext wikiContext = (XWikiContext)this.wikiContextProvider.get();
        DocumentReference eventRecClassRef = this.documentReferenceResolver.resolve((Object)"MoccaCalendar.Code.MoccaCalendarEventRecurrencyClass", new Object[0]);
        BaseObject eventRecObj = eventDoc.newXObject((EntityReference)eventRecClassRef, wikiContext);
        eventRecObj.set("firstInstance", (Object)component.getStart(), wikiContext);
        eventRecObj.set("lastInstance", (Object)component.getRecEndDate(), wikiContext);
        eventRecObj.set("frequency", (Object)component.getRecurrenceFreq().toLowerCase(), wikiContext);
        DocumentReference eventRecModifiedRef = this.documentReferenceResolver.resolve((Object)"MoccaCalendar.Code.MoccaCalendarEventModificationClass", new Object[0]);
        for (RecurrentEventModification eventModification : component.getModificationList()) {
            BaseObject eventModObj = eventDoc.newXObject((EntityReference)eventRecModifiedRef, wikiContext);
            eventModObj.set("eventOrigStartDate", (Object)eventModification.getOriginalDate(), wikiContext);
            eventModObj.set("startDate", (Object)eventModification.getModifiedStartDate(), wikiContext);
            eventModObj.set("endDate", (Object)eventModification.getModifiedEndDate(), wikiContext);
            this.addConvertedPropertyToObject(eventModification.getModifiedTitle(), eventModObj, "title");
            this.addConvertedPropertyToObject(eventModification.getModifiedDescription(), eventModObj, "description");
        }
    }

    private boolean sameNameEventExists(DocumentReference eventRef, List<XWikiDocument> eventDocuments) {
        for (XWikiDocument document : eventDocuments) {
            if (!document.getDocumentReference().equals((Object)eventRef)) continue;
            return true;
        }
        return false;
    }
}

