/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.internal.utils;

import com.xpn.xwiki.web.Utils;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.stability.Unstable;

@Unstable
public class EventQuery {
    private static final String SELECT_CLAUSE_FORMAT = ", BaseObject as obj, DateProperty as startdate, DateProperty as enddate";
    private static final String BASE_WHERE_CLAUSE_FORMAT = "WHERE obj.id=startdate.id.id and startdate.id.name='%s' and obj.id=enddate.id.id and enddate.id.name='%s' and doc.fullName=obj.name and doc.fullName!='%s' and obj.className='%s'";
    private static final String FILTER_WIKI = "wiki";
    private static final String FILTER_SPACE = "space";
    private static final String FILTER_PAGE = "page";
    private final String className;
    private final String templatePageName;
    private final String startDateName;
    private final String endDateName;
    private final String wikiId;
    private Logger logger;
    protected StringBuilder selectClause = new StringBuilder();
    protected StringBuilder whereClause = new StringBuilder();
    protected StringBuilder orderClause = new StringBuilder();
    protected Map<String, Object> queryParams = new HashMap<String, Object>();

    public EventQuery(String className, String templatePageName, String startDateName, String endDateName) {
        this(className, templatePageName, startDateName, endDateName, null);
    }

    public EventQuery(String className, String templatePageName, String startDateName, String endDateName, String wikiId) {
        this.className = className;
        this.templatePageName = templatePageName;
        this.startDateName = startDateName;
        this.endDateName = endDateName;
        this.wikiId = wikiId;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.initQuery();
    }

    public EventQuery(String className, String templatePageName) {
        this(className, templatePageName, "startDate", "endDate");
    }

    public EventQuery(String className, String templatePageName, String wiki) {
        this(className, templatePageName, "startDate", "endDate", wiki);
    }

    protected void initQuery() {
        this.selectClause.append(SELECT_CLAUSE_FORMAT);
        this.whereClause.append(String.format(BASE_WHERE_CLAUSE_FORMAT, this.startDateName, this.endDateName, this.templatePageName, this.className));
    }

    public EventQuery addSelect(String wherePart) {
        this.selectClause.append(wherePart);
        return this;
    }

    public EventQuery addObjectProperty(String propertyType, String propertyName) {
        this.addSelect(String.format(", %s as %s", propertyType, propertyName));
        this.addCondition(String.format(" and obj.id = %s.id.id and %s.id.name = '%s'", propertyName, propertyName, propertyName));
        return this;
    }

    public EventQuery addCondition(String wherePart) {
        this.whereClause.append(wherePart);
        return this;
    }

    public EventQuery addParam(String name, Object value) {
        this.queryParams.put(name, value);
        return this;
    }

    public EventQuery addDateLimits(Date dateFrom, Date dateTo) {
        this.whereClause.append(" and (enddate.value is not null and ");
        this.appendDateCriterion("enddate.value", "start", true);
        this.whereClause.append(" or ");
        this.appendDateCriterion("startdate.value", "start", true);
        this.whereClause.append(')');
        this.whereClause.append(" and ");
        this.appendDateCriterion("startdate.value", "end", false);
        this.appendDateParameters("start", dateFrom);
        this.appendDateParameters("end", dateTo);
        return this;
    }

    public EventQuery addLocationFilter(String filter, DocumentReference parentReference) {
        try {
            DefaultParameterizedType stringSerializerType = new DefaultParameterizedType(null, EntityReferenceSerializer.class, new Type[]{String.class});
            EntityReferenceSerializer compactWikiSerializer = (EntityReferenceSerializer)Utils.getComponentManager().getInstance((Type)stringSerializerType, "compact");
            switch (filter) {
                case "page": {
                    this.selectClause.append(", XWikiSpace space");
                    this.whereClause.append(" and doc.space = space.reference and space.parent = :space");
                    this.queryParams.put(FILTER_SPACE, compactWikiSerializer.serialize((EntityReference)parentReference.getLastSpaceReference(), new Object[0]));
                    break;
                }
                case "space": {
                    this.whereClause.append(" and ( doc.space like :space escape '!')");
                    String spaceRefStr = (String)compactWikiSerializer.serialize((EntityReference)parentReference.getLastSpaceReference(), new Object[0]);
                    String spaceLikeStr = spaceRefStr.replaceAll("([%_!])", "!$1").concat(".%");
                    this.queryParams.put(FILTER_SPACE, spaceLikeStr);
                    break;
                }
            }
        }
        catch (ComponentLookupException cle) {
            this.logger.warn("could not find string serializer component; location filter ignored", (Throwable)cle);
        }
        return this;
    }

    public EventQuery setAscending(boolean direction) {
        this.orderClause.append("ORDER BY startdate.value ").append(direction ? "ASC" : "DESC");
        return this;
    }

    protected void appendDateCriterion(String dateField, String prefix, boolean larger) {
        char cmpSign = larger ? (char)'>' : '<';
        this.whereClause.append("( year(" + dateField + ") ").append(cmpSign).append(" :" + prefix + "year ");
        this.whereClause.append(" or (year(" + dateField + ") = :" + prefix + "year and ");
        this.whereClause.append("(month(" + dateField + ") ").append(cmpSign).append(" :" + prefix + "month");
        this.whereClause.append(" or (month(" + dateField + ") = :" + prefix + "month ");
        this.whereClause.append(" and day(").append(dateField).append(") ").append(cmpSign).append("= :").append(prefix).append("day");
        this.whereClause.append(')');
        this.whereClause.append(')');
        this.whereClause.append(')');
        this.whereClause.append(')');
    }

    protected void appendDateParameters(String prefix, Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        this.queryParams.put(prefix + "year", year);
        this.queryParams.put(prefix + "month", month);
        this.queryParams.put(prefix + "day", day);
    }

    public String getClassName() {
        return this.className;
    }

    public String getTemplatePageName() {
        return this.templatePageName;
    }

    public String getStartDateName() {
        return this.startDateName;
    }

    public String getEndDateName() {
        return this.endDateName;
    }

    public String getWikiId() {
        return this.wikiId;
    }
}

