/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.moccacalendar.internal.utils;

import com.xpn.xwiki.XWikiContext;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.contrib.moccacalendar.internal.utils.EventQuery;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.stability.Unstable;

@Singleton
@Component(roles={DefaultEventAssembly.class})
@Unstable
public class DefaultEventAssembly {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> stringDocRefResolver;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    @Named(value="hidden")
    private QueryFilter hidden;
    @Inject
    @Named(value="document")
    private QueryFilter documentFilter;
    @Inject
    @Named(value="viewable")
    private QueryFilter viewableFilter;
    @Inject
    private Logger logger;

    public List<DocumentReference> executeQuery(EventQuery query) throws QueryException {
        StringBuilder hql = new StringBuilder();
        hql.append((CharSequence)query.selectClause).append(' ').append((CharSequence)query.whereClause).append(' ').append((CharSequence)query.orderClause);
        Query hqlQuery = this.queryManager.createQuery(hql.toString(), "hql");
        hqlQuery.setWiki(query.getWikiId());
        for (Map.Entry<String, Object> param : query.queryParams.entrySet()) {
            hqlQuery.bindValue(param.getKey(), param.getValue());
        }
        hqlQuery.addFilter(this.hidden);
        hqlQuery.addFilter(this.documentFilter);
        hqlQuery.addFilter(this.viewableFilter);
        this.logger.debug("sending query [{}] and params [{}]", (Object)hqlQuery.getStatement(), query.queryParams);
        return hqlQuery.execute();
    }
}

