/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.xpoll.script;

import com.xwiki.xpoll.XPollException;
import com.xwiki.xpoll.XPollManager;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="xpoll")
@Singleton
public class XPollScriptService
implements ScriptService {
    @Inject
    private XPollManager pollManager;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;

    public String url(DocumentReference documentReference) {
        return this.pollManager.getRestURL(documentReference);
    }

    public Map<String, Integer> getVoteResults(DocumentReference documentReference) {
        if (this.contextualAuthorizationManager.hasAccess(Right.VIEW)) {
            try {
                return this.pollManager.getVoteResults(documentReference);
            }
            catch (XPollException xPollException) {
                // empty catch block
            }
        }
        return Collections.emptyMap();
    }
}

