/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.xpoll.internal.rest;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.user.api.XWikiRightService;
import com.xwiki.xpoll.XPollException;
import com.xwiki.xpoll.XPollManager;
import com.xwiki.xpoll.rest.XPollResource;
import com.xwiki.xpoll.rest.model.jaxb.Vote;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.resources.pages.ModifiablePageResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="com.xwiki.xpoll.internal.rest.DefaultXPollResource")
@Singleton
public class DefaultXPollResource
extends ModifiablePageResource
implements XPollResource {
    private static final String POLL_PUBLICITY_PRIVATE = "private";
    @Inject
    private XPollManager xPollManager;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;
    @Inject
    private Logger logger;

    @Override
    public Response vote(String wikiName, String spaces, String pageName, Vote vote) throws XWikiRestException {
        DocumentReference documentReference = new DocumentReference(pageName, this.getSpaceReference(spaces, wikiName));
        XWikiContext context = this.getXWikiContext();
        DocumentReference userReference = context.getUserReference();
        try {
            XWikiDocument doc = context.getWiki().getDocument(documentReference, context).clone();
            BaseObject xpollObj = doc.getXObject((EntityReference)new LocalDocumentReference("XPoll", "XPollClass"));
            String pollPublicity = xpollObj.getStringValue("pollPublicity");
            if (!this.contextualAuthorizationManager.hasAccess(Right.VIEW, (EntityReference)documentReference) || XWikiRightService.isGuest((EntityReference)userReference) && pollPublicity.equals(POLL_PUBLICITY_PRIVATE)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            if ((vote.getGuestName() == null || vote.getGuestName().isEmpty()) && userReference == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            this.xPollManager.vote(documentReference, userReference, vote);
            return Response.ok().build();
        }
        catch (XWikiException e) {
            this.logger.error("Failed to get document reference", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (XPollException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e).build();
        }
    }
}

