/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.xpoll.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.xpoll.XPollException;
import com.xwiki.xpoll.XPollManager;
import com.xwiki.xpoll.internal.DefaultXPollManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="update-poll-winners")
@Singleton
public class UpdatePollWinnersListener
implements EventListener {
    private static final String XPOLL_WINNER_FIELD = "winner";
    private static final String UPDATING_FLAG = "updatingWinner";
    @Inject
    private XPollManager xPollManager;
    @Inject
    private Logger logger;
    private final List<Event> eventsList = Collections.singletonList(new DocumentUpdatedEvent());

    public String getName() {
        return "update-poll-winners";
    }

    public List<Event> getEvents() {
        return this.eventsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event event, Object source, Object data) {
        XWikiContext context = (XWikiContext)data;
        XWikiDocument doc = (XWikiDocument)source;
        BaseObject pollObject = doc.getXObject((EntityReference)DefaultXPollManager.XPOLL_CLASS_REFERENCE);
        if (pollObject != null && context.get((Object)UPDATING_FLAG) == null) {
            String oldWinner;
            String winner = "";
            String status = pollObject.getStringValue("status");
            if ("active".equals(status) || "finished".equals(status)) {
                Map<String, Integer> voteResults;
                try {
                    DocumentReference docRef = doc.getDocumentReference();
                    voteResults = this.xPollManager.getVoteResults(docRef);
                }
                catch (XPollException e) {
                    this.logger.warn(e.getMessage(), (Throwable)e);
                    return;
                }
                List<String> currentWinners = this.getWinners(voteResults);
                winner = String.join((CharSequence)",", currentWinners);
            }
            if (!(oldWinner = pollObject.getStringValue(XPOLL_WINNER_FIELD)).equals(winner)) {
                pollObject.set(XPOLL_WINNER_FIELD, (Object)winner, context);
                try {
                    context.put((Object)UPDATING_FLAG, (Object)true);
                    context.getWiki().saveDocument(doc, "Updated winner", context);
                }
                catch (XWikiException e) {
                    this.logger.warn(e.getMessage(), (Throwable)e);
                }
                finally {
                    context.put((Object)UPDATING_FLAG, null);
                }
            }
        }
    }

    private List<String> getWinners(Map<String, Integer> voteResults) {
        int maxVotes = 0;
        ArrayList<String> currentWinners = new ArrayList<String>();
        for (Map.Entry<String, Integer> proposal : voteResults.entrySet()) {
            if (proposal.getValue() == maxVotes) {
                currentWinners.add(proposal.getKey());
                continue;
            }
            if (proposal.getValue() <= maxVotes) continue;
            currentWinners.clear();
            currentWinners.add(proposal.getKey());
            maxVotes = proposal.getValue();
        }
        if (maxVotes == 0) {
            currentWinners.clear();
        }
        return currentWinners;
    }
}

