/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.xpoll.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.xpoll.PollResultsCalculator;
import com.xwiki.xpoll.XPollException;
import com.xwiki.xpoll.XPollManager;
import com.xwiki.xpoll.rest.model.jaxb.Vote;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.Cookie;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.SpaceReference;

@Component
@Singleton
public class DefaultXPollManager
implements XPollManager {
    static final String XPOLL_SPACE_NAME = "XPoll";
    static final LocalDocumentReference XPOLL_CLASS_REFERENCE = new LocalDocumentReference("XPoll", "XPollClass");
    static final LocalDocumentReference XPOLL_VOTES_CLASS_REFERENCE = new LocalDocumentReference("XPoll", "XPollVoteClass");
    static final String PROPOSALS = "proposals";
    static final String VOTES = "votes";
    static final String USER = "user";
    static final String GUEST_ID = "guestId";
    static final String COOKIE_NAME = "poll_publicity_id";
    static final String XPOLL_TYPE = "type";
    static final String XPOLL_TYPE_MULTI = "multi";
    static final String MISSING_XPOLL_OBJECT_MESSAGE = "The document [%s] does not have a poll object.";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    @Override
    public void vote(DocumentReference docReference, DocumentReference user, Vote vote) throws XPollException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            XWikiDocument document = context.getWiki().getDocument(docReference, context).clone();
            this.setUserVotes(vote, context, document, user);
        }
        catch (XWikiException e) {
            throw new XPollException(String.format("Failed to vote for [%s] on behalf of [%s].", docReference, user), e);
        }
    }

    @Override
    public String getRestURL(DocumentReference documentReference) {
        String contextPath = ((XWikiContext)this.contextProvider.get()).getRequest().getContextPath();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(contextPath);
            stringBuilder.append("/rest/wikis/");
            stringBuilder.append(URLEncoder.encode(documentReference.getWikiReference().getName(), "UTF-8"));
            for (SpaceReference spaceReference : documentReference.getSpaceReferences()) {
                stringBuilder.append("/spaces/");
                stringBuilder.append(URLEncoder.encode(spaceReference.getName(), "UTF-8"));
            }
            stringBuilder.append("/pages/");
            stringBuilder.append(URLEncoder.encode(documentReference.getName(), "UTF-8"));
            stringBuilder.append("/xpoll");
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(String.format("Failed to retrieve the REST URL of the document: [%s]", documentReference), e);
        }
    }

    @Override
    public Map<String, Integer> getVoteResults(DocumentReference documentReference) throws XPollException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            XWikiDocument doc = context.getWiki().getDocument(documentReference, context);
            BaseObject xpollObj = doc.getXObject((EntityReference)XPOLL_CLASS_REFERENCE);
            if (xpollObj == null) {
                throw new XPollException(String.format(MISSING_XPOLL_OBJECT_MESSAGE, documentReference));
            }
            String pollType = xpollObj.getStringValue(XPOLL_TYPE);
            if (pollType.isEmpty()) {
                xpollObj.set(XPOLL_TYPE_MULTI, (Object)XPOLL_TYPE_MULTI, context);
                pollType = XPOLL_TYPE_MULTI;
            }
            return this.getXPollResults(documentReference, pollType);
        }
        catch (XWikiException e) {
            throw new XPollException(String.format("Failed to retrieve the vote results for poll [%s]. Root cause: [%s].", documentReference, ExceptionUtils.getRootCauseMessage((Throwable)e)));
        }
    }

    private void setUserVotes(Vote vote, XWikiContext context, XWikiDocument doc, DocumentReference user) throws XWikiException {
        String currentUserName = (String)this.serializer.serialize((EntityReference)user, new Object[]{doc.getDocumentReference().getWikiReference()});
        Cookie cookie = context.getRequest().getCookie(COOKIE_NAME);
        BaseObject xpollVoteOfCurrentUser = this.getXPollVoteForCurrentUser(doc, currentUserName, context, cookie);
        List filteredProposals = vote.getProposals().stream().filter(p -> !p.isEmpty()).collect(Collectors.toList());
        if (cookie == null && currentUserName == null) {
            cookie = this.createCookie(context);
        }
        if (currentUserName != null) {
            xpollVoteOfCurrentUser.set(USER, (Object)currentUserName, context);
        } else {
            xpollVoteOfCurrentUser.set(USER, (Object)vote.getGuestName(), context);
        }
        xpollVoteOfCurrentUser.set(VOTES, filteredProposals, context);
        if (cookie != null && currentUserName == null) {
            xpollVoteOfCurrentUser.set(GUEST_ID, (Object)cookie.getValue(), context);
        } else {
            xpollVoteOfCurrentUser.set(GUEST_ID, null, context);
        }
        context.getWiki().saveDocument(doc, "New Vote", context);
    }

    private BaseObject getXPollVoteForCurrentUser(XWikiDocument doc, String currentUserName, XWikiContext context, Cookie cookie) throws XWikiException {
        BaseObject xpollVoteOfCurrentUser = doc.getXObject((EntityReference)XPOLL_VOTES_CLASS_REFERENCE, USER, currentUserName, false);
        if (currentUserName == null && cookie != null) {
            xpollVoteOfCurrentUser = doc.getXObject((EntityReference)XPOLL_VOTES_CLASS_REFERENCE, GUEST_ID, cookie.getValue(), false);
        }
        if (xpollVoteOfCurrentUser == null) {
            xpollVoteOfCurrentUser = doc.newXObject((EntityReference)XPOLL_VOTES_CLASS_REFERENCE, context);
        }
        return xpollVoteOfCurrentUser;
    }

    private Cookie createCookie(XWikiContext context) {
        Cookie cookie = new Cookie(COOKIE_NAME, UUID.randomUUID().toString());
        cookie.setMaxAge(31536000);
        cookie.setPath("/");
        context.getResponse().addCookie(cookie);
        return cookie;
    }

    private Map<String, Integer> getXPollResults(DocumentReference documentReference, String pollType) throws XPollException {
        try {
            ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
            PollResultsCalculator calculator = (PollResultsCalculator)componentManager.getInstance(PollResultsCalculator.class, pollType);
            return calculator.getResults(documentReference);
        }
        catch (ComponentLookupException e) {
            throw new XPollException(String.format("The results could not be calculated because the poll type [%s] lacks an implementation.", pollType));
        }
    }
}

