/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.xpoll.internal;

import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.xpoll.internal.AbstractPollResultsCalculator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Singleton
public class DefaultPollResultsCalculator
extends AbstractPollResultsCalculator {
    @Override
    public Map<String, Integer> calculateResults(List<BaseObject> xpollVotes, List<String> proposals) {
        HashMap<String, Integer> voteCount = new HashMap<String, Integer>();
        for (String proposal : proposals) {
            voteCount.put(proposal, 0);
        }
        for (BaseObject xpollVote : xpollVotes) {
            List currentVotes = xpollVote.getListValue("votes");
            for (String currentVote : currentVotes) {
                if (!proposals.contains(currentVote)) continue;
                int nbvotes = (Integer)voteCount.get(currentVote) + 1;
                voteCount.put(currentVote, nbvotes);
            }
        }
        return voteCount;
    }
}

