/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.xpoll.internal;

import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.xpoll.internal.AbstractPollResultsCalculator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;

@Component
@Named(value="condorcet")
@Singleton
public class CondorcetPollResultsCalculator
extends AbstractPollResultsCalculator {
    @Override
    public Map<String, Integer> calculateResults(List<BaseObject> xpollVotes, List<String> proposals) {
        Map<String, Map<String, Integer>> ballotsMatrix = this.initializeProposalsMap(proposals);
        this.computeProposalWeights(xpollVotes, ballotsMatrix, proposals);
        Map<String, Map<String, Integer>> computedPreferences = this.initializeProposalsMap(proposals);
        this.computeProposalStronghestPaths(proposals, ballotsMatrix, computedPreferences);
        HashMap<String, Integer> scores = new HashMap<String, Integer>();
        for (String preference1 : computedPreferences.keySet()) {
            for (String preference2 : computedPreferences.get(preference1).keySet()) {
                int value = scores.getOrDefault(preference1, 0);
                if (preference1.equals(preference2)) continue;
                if (computedPreferences.get(preference1).get(preference2) >= computedPreferences.get(preference2).get(preference1)) {
                    scores.put(preference1, ++value);
                    continue;
                }
                scores.put(preference1, value);
            }
        }
        return scores;
    }

    private Map<String, Map<String, Integer>> initializeProposalsMap(List<String> proposals) {
        HashMap<String, Map<String, Integer>> map = new HashMap<String, Map<String, Integer>>();
        for (String proposal : proposals) {
            map.put(proposal, new HashMap());
            for (String otherProposal : proposals) {
                ((Map)map.get(proposal)).put(otherProposal, 0);
            }
        }
        return map;
    }

    private void computeProposalStronghestPaths(List<String> proposals, Map<String, Map<String, Integer>> ballotsMatrix, Map<String, Map<String, Integer>> p) {
        for (String p1 : ballotsMatrix.keySet()) {
            for (String p2 : ballotsMatrix.get(p1).keySet()) {
                this.updateValue(ballotsMatrix, p, p1, p2);
            }
        }
        for (String i : ballotsMatrix.keySet()) {
            for (String j : ballotsMatrix.get(i).keySet()) {
                if (i.equals(j)) continue;
                for (String k : proposals) {
                    if (i.equals(k) || j.equals(k)) continue;
                    p.get(j).put(k, Math.max(p.get(j).get(k), Math.min(p.get(j).get(i), p.get(i).get(k))));
                }
            }
        }
    }

    private void updateValue(Map<String, Map<String, Integer>> ballotsMatrix, Map<String, Map<String, Integer>> p, String p1, String p2) {
        if (!p1.equals(p2)) {
            if (ballotsMatrix.get(p1).get(p2) > ballotsMatrix.get(p2).get(p1)) {
                p.get(p1).put(p2, ballotsMatrix.get(p1).get(p2));
            } else {
                p.get(p1).put(p2, 0);
            }
        }
    }

    private void computeProposalWeights(List<BaseObject> xpollVotes, Map<String, Map<String, Integer>> ballotsMatrix, List<String> proposals) {
        for (BaseObject xpollVote : xpollVotes) {
            ArrayList<String> notVotedProposals = new ArrayList<String>(proposals);
            List currentVotes = xpollVote.getListValue("votes");
            notVotedProposals.removeAll(currentVotes);
            for (int i = 0; i < currentVotes.size(); ++i) {
                Map<String, Integer> line = ballotsMatrix.get(currentVotes.get(i));
                for (int j = i + 1; j < currentVotes.size(); ++j) {
                    int value = line.get(currentVotes.get(j));
                    line.put((String)currentVotes.get(j), value + 1);
                }
                for (String notVotedProposal : notVotedProposals) {
                    int value = line.get(notVotedProposal);
                    line.put(notVotedProposal, value + 1);
                }
            }
        }
    }
}

