/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.xpoll.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.xpoll.PollResultsCalculator;
import com.xwiki.xpoll.XPollException;
import com.xwiki.xpoll.internal.DefaultXPollManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public abstract class AbstractPollResultsCalculator
implements PollResultsCalculator {
    @Inject
    private Provider<XWikiContext> contextProvider;

    @Override
    public Map<String, Integer> getResults(DocumentReference documentReference) throws XPollException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            XWikiDocument document = context.getWiki().getDocument(documentReference, context);
            BaseObject xpollObj = document.getXObject((EntityReference)DefaultXPollManager.XPOLL_CLASS_REFERENCE);
            if (xpollObj == null) {
                throw new XPollException(String.format("The document [%s] does not have a poll object.", document.getDocumentReference()));
            }
            List xpollVotes = document.getXObjects((EntityReference)DefaultXPollManager.XPOLL_VOTES_CLASS_REFERENCE);
            xpollVotes.removeAll(Collections.singletonList(null));
            List proposals = xpollObj.getListValue("proposals");
            return this.calculateResults(xpollVotes, proposals);
        }
        catch (XWikiException e) {
            throw new XPollException(String.format("Failed to compute the results for the poll [%s].", documentReference), e);
        }
    }

    protected abstract Map<String, Integer> calculateResults(List<BaseObject> var1, List<String> var2);
}

