/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.application.task.test.po;

import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;
import org.xwiki.test.ui.po.InlinePage;
import org.xwiki.test.ui.po.SuggestInputElement;

public class TaskManagerInlinePage
extends InlinePage {
    private static final String CLASS_PREFIX = "TaskManager.TaskManagerClass_0_";
    @FindBy(id="TaskManager.TaskManagerClass_0_name")
    private WebElement nameElement;
    @FindBy(id="TaskManager.TaskManagerClass_0_project")
    private WebElement projectElement;
    @FindBy(id="TaskManager.TaskManagerClass_0_creationdate")
    private WebElement creationDateElement;
    @FindBy(id="TaskManager.TaskManagerClass_0_duedate")
    private WebElement dueDateElement;
    @FindBy(id="TaskManager.TaskManagerClass_0_startDate")
    private WebElement startDateElement;
    @FindBy(id="TaskManager.TaskManagerClass_0_severity")
    private WebElement severityElement;
    @FindBy(name="TaskManager.TaskManagerClass_0_reporter")
    private WebElement reporterElement;
    @FindBy(id="TaskManager.TaskManagerClass_0_assignee")
    private WebElement assigneeElement;
    @FindBy(id="TaskManager.TaskManagerClass_0_status")
    private WebElement statusElement;
    @FindBy(id="TaskManager.TaskManagerClass_0_progress")
    private WebElement progressElement;

    public void setName(String name) {
        this.nameElement.clear();
        this.nameElement.sendKeys(new CharSequence[]{name});
    }

    public void setProject(String project) {
        Select projectSelect = new Select(this.projectElement);
        projectSelect.selectByValue(project);
    }

    public String getCreationDate() {
        return this.creationDateElement.getAttribute("id");
    }

    public void setDueDate(String dueDate) {
        this.dueDateElement.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
        this.dueDateElement.sendKeys(new CharSequence[]{dueDate});
        this.dueDateElement.sendKeys(new CharSequence[]{Keys.ENTER});
    }

    public void setStartDate(String startDate) {
        this.startDateElement.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
        this.startDateElement.sendKeys(new CharSequence[]{startDate});
        this.startDateElement.sendKeys(new CharSequence[]{Keys.ENTER});
    }

    public void clearStartDate() {
        this.startDateElement.clear();
    }

    public void setSeverity(String severity) {
        Select severitySelect = new Select(this.severityElement);
        severitySelect.selectByValue(severity);
    }

    public String getReporter() {
        return this.reporterElement.getAttribute("value");
    }

    public void setAssignee(String assignee) {
        if (assignee.isEmpty()) {
            new SuggestInputElement(this.assigneeElement).clearSelectedSuggestions();
        } else {
            new SuggestInputElement(this.assigneeElement).clearSelectedSuggestions().sendKeys(new CharSequence[]{assignee}).selectTypedText();
        }
    }

    public void setStatus(String status) {
        Select statusSelect = new Select(this.statusElement);
        statusSelect.selectByValue(status);
    }

    public void setProgress(String progress) {
        this.progressElement.clear();
        this.progressElement.sendKeys(new CharSequence[]{progress});
    }
}

