/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.application.task.test.po;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.xwiki.test.ui.po.ViewPage;

public class TaskManagerGanttMacro
extends ViewPage {
    public static final List<String> viewModes = Arrays.asList("Quarter Day", "Half Day", "Day", "Week", "Month", "Year");
    private final WebElement ganttElement;

    public TaskManagerGanttMacro(WebElement ganttElement) {
        this.ganttElement = ganttElement;
        this.getDriver().waitUntilCondition(ExpectedConditions.presenceOfElementLocated((By)By.cssSelector((String)".gantt-container, .box")));
    }

    public static List<TaskManagerGanttMacro> getGanttMacrosOnCurrentPage() {
        return TaskManagerGanttMacro.getUtil().getDriver().findElements(By.cssSelector((String)"div[id^='taskgantt-gantt']")).stream().map(ganttElement -> new TaskManagerGanttMacro((WebElement)ganttElement)).collect(Collectors.toList());
    }

    public void changeViewMode(String viewMode) {
        this.ganttElement.findElement(By.cssSelector((String)(".view-mode-button[value='" + viewMode + "']"))).click();
    }

    public boolean isOverlayActive() {
        return !this.ganttElement.findElements(By.cssSelector((String)".taskgantt-noedit-overlay.active")).isEmpty();
    }

    public WebElement getTaskBar(String id) throws NoSuchElementException {
        return this.getSvgGantt().findElement(By.cssSelector((String)(".bar-wrapper[data-id='" + id + "']")));
    }

    public List<String> getTaskIds() {
        if (this.getSvgGantt() != null) {
            return this.getSvgGantt().findElements(By.cssSelector((String)".bar-wrapper")).stream().map(elem -> elem.getAttribute("data-id")).collect(Collectors.toList());
        }
        return List.of();
    }

    public void openTaskPage(String id) {
        WebElement taskBar = this.getTaskBar(id).findElement(By.cssSelector((String)".bar"));
        Actions builder = new Actions((WebDriver)this.getDriver().getWrappedDriver());
        builder.moveToElement(this.ganttElement).doubleClick(taskBar).perform();
    }

    public void dragTaskStart(String id, int offset) {
        WebElement taskBar = this.getTaskBar(id);
        WebElement startHandle = taskBar.findElement(By.cssSelector((String)".handle.left"));
        this.dragElementHorizontal(startHandle, offset);
    }

    public void dragTaskEnd(String id, int offset) {
        WebElement taskBar = this.getTaskBar(id);
        WebElement endHandle = taskBar.findElement(By.cssSelector((String)".handle.right"));
        this.dragElementHorizontal(endHandle, offset);
    }

    public boolean dragProgress(String id, int offset) {
        WebElement taskBar = this.getTaskBar(id);
        try {
            WebElement progressHandle = taskBar.findElement(By.cssSelector((String)".handle.progress"));
            this.dragElementHorizontal(progressHandle, offset);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public void dragTask(String id, int offset) {
        WebElement taskBar = this.getTaskBar(id).findElement(By.cssSelector((String)".bar"));
        this.dragElementHorizontal(taskBar, offset);
    }

    private WebElement getSvgGantt() {
        List svgGantt = this.ganttElement.findElements(By.cssSelector((String)"svg.gantt"));
        return svgGantt.isEmpty() ? null : (WebElement)svgGantt.get(0);
    }

    private void dragElementHorizontal(WebElement element, int offset) {
        Actions dragAndDrop = new Actions((WebDriver)this.getDriver().getWrappedDriver()).moveToElement(this.ganttElement).clickAndHold(element).moveByOffset(offset, 0).release();
        dragAndDrop.perform();
    }
}

