/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.contrib.application.task.test.po;

import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.ui.Select;
import org.xwiki.administration.test.po.AdministrationSectionPage;

public class TaskAdminPage
extends AdministrationSectionPage {
    private static final String SECTION_ID = "Task Manager";
    @FindBy(id="TaskManager.TaskManagerClass_0_defaultInlineStatus")
    private WebElement defaultInlineStatusElement;
    @FindBy(id="project")
    private WebElement addProjectTextInput;
    @FindBy(id="severity")
    private WebElement addSeverityTextInput;
    @FindBy(id="status")
    private WebElement addStatusTextInput;
    private Select defaultInlineStatusSelect;

    public static TaskAdminPage gotoPage() {
        AdministrationSectionPage.gotoPage((String)SECTION_ID);
        return new TaskAdminPage();
    }

    public void forceEdit() {
        this.getDriver().navigate().to(this.getDriver().getCurrentUrl() + "&forceEdit=1&force=1");
    }

    public TaskAdminPage() {
        super(SECTION_ID);
    }

    public String getDefaultInlineStatusValue() {
        return this.getDefaultInlineStatusSelect().getFirstSelectedOption().getText();
    }

    public void setDefaultInlineStatusValue(String value) {
        this.getDefaultInlineStatusSelect().selectByVisibleText(value);
    }

    public void addNewProject(String projectName) {
        this.addProjectTextInput.click();
        this.addProjectTextInput.clear();
        this.addProjectTextInput.sendKeys(new CharSequence[]{projectName});
        this.addProjectTextInput.sendKeys(new CharSequence[]{Keys.ENTER});
        this.getDriver().waitUntilPageIsReloaded();
    }

    public void addNewSeverity(String severityName) {
        this.addSeverityTextInput.click();
        this.addSeverityTextInput.clear();
        this.addSeverityTextInput.sendKeys(new CharSequence[]{severityName});
        this.addSeverityTextInput.sendKeys(new CharSequence[]{Keys.ENTER});
        this.getDriver().waitUntilPageIsReloaded();
    }

    public void addNewStatus(String statusName) {
        this.addStatusTextInput.click();
        this.addStatusTextInput.clear();
        this.addStatusTextInput.sendKeys(new CharSequence[]{statusName});
        this.addStatusTextInput.sendKeys(new CharSequence[]{Keys.ENTER});
        this.getDriver().waitUntilPageIsReloaded();
    }

    private Select getDefaultInlineStatusSelect() {
        if (this.defaultInlineStatusSelect == null) {
            this.defaultInlineStatusSelect = new Select(this.defaultInlineStatusElement);
        }
        return this.defaultInlineStatusSelect;
    }

    public int countSectionElements(String sectionId) {
        return this.getDriver().findElements(By.cssSelector((String)(sectionId + " .actiondelete"))).size();
    }
}

