/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal.rest;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.task.internal.MacroBlockFinder;
import com.xwiki.task.rest.TaskboxResource;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="com.xwiki.task.internal.rest.DefaultTaskboxResource")
@Singleton
public class DefaultTaskboxResource
extends XWikiResource
implements TaskboxResource {
    private static final Set<String> TRUE_VALUES = Set.of("true", "1");
    private static final Set<String> FALSE_VALUES = Set.of("false", "0");
    private static final String PARAM_CHECKED = "checked";
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;
    @Inject
    private MacroBlockFinder macroBlockFinder;

    public Response changeTaskStatus(String wikiName, String spaces, String pageName, String id, String checked) throws XWikiRestException {
        DocumentReference docRef = new DocumentReference(pageName, this.getSpaceReference(spaces, wikiName));
        if (!TRUE_VALUES.contains(checked) && !FALSE_VALUES.contains(checked)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.contextualAuthorizationManager.hasAccess(Right.EDIT, (EntityReference)docRef)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        XWikiContext context = this.getXWikiContext();
        XWikiDocument document = null;
        try {
            document = context.getWiki().getDocument(docRef, context);
        }
        catch (XWikiException e) {
            throw new XWikiRestException("Could not retrieve document.", (Throwable)e);
        }
        if (document.isNew()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        XDOM docDOM = document.getXDOM();
        XDOM updatedXDOM = this.maybeUpdateTaskbox(id, checked, docDOM, document);
        if (updatedXDOM != null) {
            try {
                document.setContent(docDOM);
                context.getWiki().saveDocument(document, String.format("Updated the checkbox with id [%s].", id), context);
                return Response.ok().build();
            }
            catch (XWikiException e) {
                throw new XWikiRestException("Failed to update the content of the page.", (Throwable)e);
            }
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private XDOM maybeUpdateTaskbox(String id, String checked, XDOM docDOM, XWikiDocument document) {
        AtomicReference<Boolean> contentChanged = new AtomicReference<Boolean>(false);
        XDOM updatedXDOM = this.macroBlockFinder.find(docDOM, document.getSyntax(), macroBlock -> {
            if (!"checkbox".equals(macroBlock.getId())) {
                return MacroBlockFinder.Lookup.CONTINUE;
            }
            String macroId = macroBlock.getParameters().getOrDefault("id", "");
            if (!id.equals(macroId)) {
                return MacroBlockFinder.Lookup.CONTINUE;
            }
            String macroChecked = macroBlock.getParameters().getOrDefault(PARAM_CHECKED, "");
            if (macroChecked.isEmpty() && Boolean.FALSE.toString().equals(checked) || checked.equals(macroChecked)) {
                return MacroBlockFinder.Lookup.BREAK;
            }
            macroBlock.setParameter(PARAM_CHECKED, checked);
            contentChanged.set(true);
            return MacroBlockFinder.Lookup.BREAK;
        });
        if (contentChanged.get().booleanValue()) {
            return updatedXDOM;
        }
        return null;
    }
}

