/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal.rest;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.task.TaskConfiguration;
import com.xwiki.task.rest.TaskResource;
import java.util.Collections;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.resources.pages.ModifiablePageResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="com.xwiki.task.internal.rest.DefaultTaskResource")
@Singleton
public class DefaultTaskResource
extends ModifiablePageResource
implements TaskResource {
    private static final LocalDocumentReference TASK_CLASS_REFERENCE = new LocalDocumentReference(Collections.singletonList("TaskManager"), "TaskManagerClass");
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userRefResolver;
    @Inject
    private TaskConfiguration taskConfiguration;

    public Response changeTaskStatus(String wikiName, String spaces, String pageName, String status) throws XWikiRestException {
        DocumentReference docRef = new DocumentReference(pageName, this.getSpaceReference(spaces, wikiName));
        if (!this.contextualAuthorizationManager.hasAccess(Right.EDIT, (EntityReference)docRef)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        try {
            XWikiDocument document = this.getXWikiContext().getWiki().getDocument(docRef, this.getXWikiContext()).clone();
            UserReference currentUserReference = this.userRefResolver.resolve((Object)this.getXWikiContext().getUserReference(), new Object[0]);
            document.getAuthors().setOriginalMetadataAuthor(currentUserReference);
            BaseObject taskObject = document.getXObject((EntityReference)TASK_CLASS_REFERENCE);
            if (taskObject == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String setStatus = taskObject.getStringValue("status");
            String newStatus = status;
            if ("toggle".equals(status)) {
                newStatus = setStatus.equals("Done") ? this.taskConfiguration.getDefaultInlineStatus() : "Done";
            }
            taskObject.set("status", (Object)newStatus, this.getXWikiContext());
            Date completeDate = null;
            int progress = 0;
            if (newStatus.equals("Done")) {
                completeDate = new Date();
                progress = 100;
            }
            taskObject.set("progress", (Object)progress, this.getXWikiContext());
            taskObject.set("completeDate", (Object)completeDate, this.getXWikiContext());
            this.getXWikiContext().getWiki().saveDocument(document, "Task status was updated.", this.getXWikiContext());
            return Response.ok().build();
        }
        catch (XWikiException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

