/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal.rest;

import com.xwiki.task.TaskException;
import com.xwiki.task.TaskReferenceGenerator;
import com.xwiki.task.rest.TaskReferenceResource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.PageReferenceResolver;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="com.xwiki.task.internal.rest.DefaultTaskReferenceResource")
@Singleton
public class DefaultTaskReferenceResource
extends XWikiResource
implements TaskReferenceResource {
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;
    @Inject
    private TaskReferenceGenerator taskReferenceGenerator;
    @Inject
    @Named(value="supercompact")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private PageReferenceResolver<EntityReference> pageReferenceResolver;

    public String generateId(String wikiName, String spaces, String pageName) throws XWikiRestException {
        DocumentReference ownerRef = new DocumentReference(pageName, this.getSpaceReference(spaces, wikiName));
        DocumentReference docRef = new DocumentReference(pageName, new SpaceReference("Tasks", this.getSpaceReference(spaces, wikiName)));
        if (!this.contextualAuthorizationManager.hasAccess(Right.EDIT, (EntityReference)docRef)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        try {
            return (String)this.serializer.serialize((EntityReference)this.pageReferenceResolver.resolve((Object)this.taskReferenceGenerator.generate(docRef), new Object[0]), new Object[]{ownerRef});
        }
        catch (TaskException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

