/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal.notifications.taskchanged;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectUpdatedEvent;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xwiki.task.internal.notifications.taskchanged.TaskChangedEventFactory;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.BeginFoldEvent;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="com.xwiki.task.internal.notifications.taskchanged.TaskChangedEventNotificationListener")
public class TaskChangedEventNotificationListener
extends AbstractEventListener {
    public static final List<String> WATCHED_FIELDS = Arrays.asList("assignee", "duedate", "project", "status", "severity", "progress");
    private static final EntityReference CLASS_MATCHER = BaseObjectReference.any((String)"TaskManager.TaskManagerClass");
    private static final BeginEvent FOLD_EVENT_MATCHER = event -> event instanceof BeginFoldEvent;
    @Inject
    private TaskChangedEventFactory taskChangedEventFactory;
    @Inject
    private Provider<ObservationManager> observationManagerProvider;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private ObservationContext observationContext;

    public TaskChangedEventNotificationListener() {
        super(TaskChangedEventNotificationListener.class.getName(), Arrays.asList(new XObjectUpdatedEvent(CLASS_MATCHER), new XObjectAddedEvent(CLASS_MATCHER)));
    }

    public void onEvent(Event event, Object source, Object data) {
        List<String> events;
        if (this.observationContext.isIn(FOLD_EVENT_MATCHER)) {
            return;
        }
        if (event instanceof XObjectUpdatedEvent) {
            events = WATCHED_FIELDS;
        } else if (event instanceof XObjectAddedEvent) {
            events = List.of("assignee");
        } else {
            return;
        }
        XWikiDocument sourceDoc = (XWikiDocument)source;
        this.taskChangedEventFactory.getEvents(sourceDoc, events).forEach(taskEvent -> ((ObservationManager)this.observationManagerProvider.get()).notify((Event)taskEvent, (Object)sourceDoc.toString(), this.contextProvider.get()));
    }
}

