/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal.notifications.taskchanged;

import com.xwiki.task.internal.notifications.taskchanged.TaskChangedEvent;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.EventFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.watch.WatchedEntitiesManager;
import org.xwiki.notifications.filters.watch.WatchedEntityFactory;
import org.xwiki.notifications.filters.watch.WatchedEntityReference;
import org.xwiki.notifications.filters.watch.WatchedLocationReference;
import org.xwiki.notifications.notifiers.internal.UserEventManager;
import org.xwiki.notifications.preferences.NotificationPreferenceManager;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="com.xwiki.task.internal.notifications.taskchanged.TaskChangedEventListener")
public class TaskChangedEventListener
extends AbstractEventListener {
    @Inject
    private WatchedEntityFactory watchedEntityFactory;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private WatchedEntitiesManager watchedEntitiesManager;
    @Inject
    private NotificationPreferenceManager notificationPreferenceManager;
    @Inject
    private Logger logger;
    @Inject
    private UserEventManager userEventManager;
    @Inject
    private EventFactory eventFactory;

    public TaskChangedEventListener() {
        super(TaskChangedEventListener.class.getName(), List.of(new TaskChangedEvent()));
    }

    public void onEvent(Event event, Object source, Object data) {
        if (!(event instanceof TaskChangedEvent)) {
            return;
        }
        TaskChangedEvent taskChangedEvent = (TaskChangedEvent)event;
        if (!taskChangedEvent.getType().equals("assignee")) {
            return;
        }
        WatchedLocationReference docRef = this.watchedEntityFactory.createWatchedLocationReference((EntityReference)taskChangedEvent.getDocument().getDocumentReference());
        this.watchTask(docRef, (String)taskChangedEvent.getCurrentValue());
        this.unwatchTask(docRef, (String)taskChangedEvent.getPreviousValue());
    }

    private boolean hasTaskNotificationPreferenceEnabled(DocumentReference user) {
        org.xwiki.eventstream.Event event = this.eventFactory.createRawEvent();
        event.setType(TaskChangedEvent.class.getName());
        return this.userEventManager.isListening(event, user, NotificationFormat.ALERT) || this.userEventManager.isListening(event, user, NotificationFormat.EMAIL);
    }

    private void watchTask(WatchedLocationReference docRef, String userFullName) {
        if (userFullName != null && !userFullName.isEmpty()) {
            DocumentReference user = this.documentReferenceResolver.resolve((Object)userFullName, new Object[0]);
            if (!this.hasTaskNotificationPreferenceEnabled(user)) {
                return;
            }
            try {
                List preferences = this.notificationPreferenceManager.getAllPreferences(user);
                this.watchedEntitiesManager.watchEntity((WatchedEntityReference)docRef, user);
                this.notificationPreferenceManager.savePreferences(preferences);
            }
            catch (NotificationException e) {
                this.logger.error("Failed to watch task page [{}] for user [{}] after assignee changes. Root cause: [{}]", new Object[]{docRef, userFullName, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
    }

    private void unwatchTask(WatchedLocationReference docRef, String userFullName) {
        if (userFullName != null && !userFullName.isEmpty()) {
            DocumentReference user = this.documentReferenceResolver.resolve((Object)userFullName, new Object[0]);
            if (!this.hasTaskNotificationPreferenceEnabled(user)) {
                return;
            }
            try {
                List preferences = this.notificationPreferenceManager.getAllPreferences(user);
                this.watchedEntitiesManager.unwatchEntity((WatchedEntityReference)docRef, user);
                this.notificationPreferenceManager.savePreferences(preferences);
            }
            catch (NotificationException e) {
                this.logger.error("Failed to unwatch task page [{}] for user [{}] after assignee changes. Root cause: [{}]", new Object[]{docRef, userFullName, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
    }
}

