/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal.notifications.taskchanged;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.DateProperty;
import com.xpn.xwiki.objects.IntegerProperty;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.StringProperty;
import com.xwiki.task.internal.notifications.taskchanged.TaskChangedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;

@Component(roles={TaskChangedEventFactory.class})
@Singleton
public class TaskChangedEventFactory {
    private static final LocalDocumentReference TASK_CLASS = new LocalDocumentReference("TaskManager", "TaskManagerClass");

    public List<TaskChangedEvent> getEvents(XWikiDocument sourceDoc, List<String> watchedFields) {
        XWikiDocument previousDoc = sourceDoc.getOriginalDocument();
        BaseObject currentObject = sourceDoc.getXObject((EntityReference)TASK_CLASS);
        BaseObject previousObject = previousDoc == null ? null : previousDoc.getXObject((EntityReference)TASK_CLASS);
        ArrayList<TaskChangedEvent> events = new ArrayList<TaskChangedEvent>();
        watchedFields.forEach(field -> {
            Optional<TaskChangedEvent> taskChangedEvent = this.getFieldChangedEvent(currentObject, previousObject, (String)field, sourceDoc);
            taskChangedEvent.ifPresent(events::add);
        });
        return events;
    }

    private Optional<Object> getPropertyValue(BaseObject obj, String propertyName) {
        Optional<Object> optional;
        if (null == obj) {
            return Optional.empty();
        }
        PropertyInterface property = obj.safeget(propertyName);
        if (property instanceof StringProperty) {
            optional = Optional.ofNullable(((StringProperty)property).getValue());
        } else if (property instanceof LargeStringProperty) {
            optional = Optional.ofNullable(((LargeStringProperty)property).getValue());
        } else if (property instanceof DateProperty) {
            optional = Optional.ofNullable(((DateProperty)property).getValue());
        } else if (property instanceof IntegerProperty) {
            Integer value = (Integer)((IntegerProperty)property).getValue();
            if (value == null) {
                value = 0;
            }
            optional = Optional.of(value);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    private Optional<TaskChangedEvent> getFieldChangedEvent(BaseObject currentObject, BaseObject previousObject, String propertyName, XWikiDocument taskPage) {
        boolean valuesAreEqual;
        Object currentValue = this.getPropertyValue(currentObject, propertyName).orElse(null);
        Object previousValue = this.getPropertyValue(previousObject, propertyName).orElse(null);
        if (currentValue != null) {
            valuesAreEqual = currentValue.equals(previousValue);
        } else {
            boolean bl = valuesAreEqual = previousValue == null;
        }
        if (valuesAreEqual) {
            return Optional.empty();
        }
        TaskChangedEvent event = new TaskChangedEvent(taskPage);
        event.setType(propertyName);
        if (currentValue != null) {
            event.setCurrentValue(currentValue);
        }
        if (previousValue != null) {
            event.setPreviousValue(previousValue);
        }
        return Optional.of(event);
    }
}

