/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal.notifications.taskchanged;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.task.internal.notifications.taskchanged.TaskChangedEvent;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.RecordableEvent;
import org.xwiki.eventstream.RecordableEventConverter;

@Singleton
@Named(value="com.xwiki.task.internal.notifications.taskchanged.TaskChangedEventConverter")
@Component
public class TaskChangedEventConverter
implements RecordableEventConverter {
    @Inject
    private RecordableEventConverter defaultConverter;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;

    public Event convert(RecordableEvent recordableEvent, String source, Object data) throws Exception {
        TaskChangedEvent event = (TaskChangedEvent)recordableEvent;
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWikiDocument document = event.getDocument();
        Event convertedEvent = this.defaultConverter.convert((RecordableEvent)event, source, data);
        convertedEvent.setApplication("TaskManager");
        convertedEvent.setDocument(document.getDocumentReference());
        convertedEvent.setDocumentVersion(document.getVersion());
        convertedEvent.setDocumentTitle(document.getRenderedTitle(context));
        convertedEvent.setBody(this.serializeParams(event.getEventInfo()));
        return convertedEvent;
    }

    public List<RecordableEvent> getSupportedEvents() {
        return List.of(new TaskChangedEvent());
    }

    private String serializeParams(Map<String, Object> params) {
        String json = null;
        try {
            ObjectWriter ow = new ObjectMapper().writer();
            json = ow.writeValueAsString(params);
        }
        catch (Exception e) {
            this.logger.warn("Error while serializing parameters of TaskChangedEvent:", (Throwable)e);
        }
        return json;
    }
}

