/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal.macro;

import com.xwiki.date.DateMacroConfiguration;
import com.xwiki.task.MacroUtils;
import com.xwiki.task.TaskException;
import com.xwiki.task.TaskManager;
import com.xwiki.task.internal.TaskBlockProcessor;
import com.xwiki.task.macro.TasksMacroParameters;
import com.xwiki.task.model.Task;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="tasks")
@Singleton
public class TasksMacro
extends AbstractMacro<TasksMacroParameters> {
    @Inject
    private TaskBlockProcessor blockProcessor;
    @Inject
    private TaskManager taskManager;
    @Inject
    private DateMacroConfiguration dateMacroConfiguration;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private ContextualAuthorizationManager authorizationManager;
    @Inject
    private ContextualLocalizationManager localizationManager;
    @Inject
    private MacroUtils macroUtils;

    public TasksMacro() {
        super("Tasks", "Display one or more tasks identified by their IDs.", TasksMacroParameters.class);
        this.setDefaultCategories(Collections.singleton("Content"));
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public List<Block> execute(TasksMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        String ids = parameters.getIds();
        ArrayList<Block> blocks = new ArrayList<Block>();
        SimpleDateFormat storageFormat = new SimpleDateFormat(this.dateMacroConfiguration.getStorageDateFormat());
        ArrayList<MacroBlock> errorList = new ArrayList<MacroBlock>();
        boolean noViewRights = false;
        for (String id : ids.split("\\s*,\\s*")) {
            try {
                Task task = this.taskManager.getTask(Integer.parseInt(id));
                if (!this.authorizationManager.hasAccess(Right.VIEW, (EntityReference)task.getReference())) {
                    noViewRights = true;
                    continue;
                }
                HashMap<String, String> taskParams = new HashMap<String, String>();
                taskParams.put("reference", (String)this.serializer.serialize((EntityReference)task.getReference(), new Object[0]));
                taskParams.put("status", task.getStatus());
                taskParams.put("reporter", (String)this.serializer.serialize((EntityReference)task.getReporter(), new Object[0]));
                taskParams.put("createDate", task.getCreateDate() != null ? storageFormat.format(task.getCreateDate()) : "");
                taskParams.put("completeDate", task.getCompleteDate() != null ? storageFormat.format(task.getCompleteDate()) : "");
                String taskContent = this.macroUtils.renderMacroContent(this.blockProcessor.generateTaskContentBlocks(task.getAssignee() != null ? (String)this.serializer.serialize((EntityReference)task.getAssignee(), new Object[0]) : null, task.getDueDate(), task.getName(), storageFormat), context.getSyntax());
                blocks.add((Block)new MacroBlock("task", taskParams, taskContent, false));
            }
            catch (TaskException | NumberFormatException | ComponentLookupException e) {
                errorList.add(new MacroBlock("error", Collections.emptyMap(), ExceptionUtils.getRootCauseMessage((Throwable)e), false));
            }
        }
        if (noViewRights) {
            blocks.add(0, (Block)new MacroBlock("warning", Collections.emptyMap(), this.localizationManager.getTranslationPlain("taskmanager.macro.tasks.noRights", new Object[0]), false));
        }
        blocks.addAll(errorList);
        return blocks;
    }
}

