/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal.macro;

import com.xwiki.task.MacroUtils;
import com.xwiki.task.TaskConfiguration;
import com.xwiki.task.macro.TaskMacroParameters;
import com.xwiki.task.macro.TaskboxMacroParameters;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="checkbox")
@Singleton
public class TaskboxMacro
extends AbstractMacro<TaskboxMacroParameters> {
    @Inject
    private MacroUtils macroUtils;
    @Inject
    private TaskConfiguration taskConfiguration;

    public TaskboxMacro() {
        super("name", "description", (ContentDescriptor)new DefaultContentDescriptor("Content of the task.", false, Block.LIST_BLOCK_TYPE), TaskboxMacroParameters.class);
        this.setDefaultCategories(Collections.singleton("Content"));
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public List<Block> execute(TaskboxMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        HashMap<String, String> taskParams = new HashMap<String, String>();
        taskParams.put("status", parameters.isChecked() ? "Done" : this.taskConfiguration.getDefaultInlineStatus());
        taskParams.put("idDisplayed", TaskMacroParameters.IdDisplay.FALSE.name());
        taskParams.put("reference", parameters.getId());
        taskParams.put("className", "taskbox");
        MacroBlock taskMacroBlock = new MacroBlock("task", taskParams, content, false);
        return Collections.singletonList(taskMacroBlock);
    }
}

