/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal.macro;

import com.xwiki.task.MacroUtils;
import com.xwiki.task.TaskConfiguration;
import com.xwiki.task.TaskException;
import com.xwiki.task.TaskManager;
import com.xwiki.task.internal.TaskBlockProcessor;
import com.xwiki.task.internal.TaskReferenceUtils;
import com.xwiki.task.macro.TaskMacroParameters;
import com.xwiki.task.model.Task;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.skinx.SkinExtension;
import org.xwiki.xml.XMLUtils;

@Component
@Named(value="task")
@Singleton
public class TaskMacro
extends AbstractMacro<TaskMacroParameters> {
    public static final String SKIN_RESOURCES_DOCUMENT_REFERENCE = "TaskManager.SkinExtensions";
    private static final String HTML_CLASS = "class";
    @Inject
    private TaskBlockProcessor taskBlockProcessor;
    @Inject
    @Named(value="ssx")
    private SkinExtension ssx;
    @Inject
    @Named(value="jsx")
    private SkinExtension jsx;
    @Inject
    private TaskManager taskManager;
    @Inject
    private MacroUtils macroUtils;
    @Inject
    @Named(value="macro")
    private DocumentReferenceResolver<String> macroDocumentReferenceResolver;
    @Inject
    private TaskReferenceUtils taskReferenceUtils;
    @Inject
    private TaskConfiguration taskConfiguration;

    public TaskMacro() {
        super("name", "description", (ContentDescriptor)new DefaultContentDescriptor("Content of the task.", false, Block.LIST_BLOCK_TYPE), TaskMacroParameters.class);
        this.setDefaultCategories(Collections.singleton("Content"));
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public List<Block> execute(TaskMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        this.ssx.use(SKIN_RESOURCES_DOCUMENT_REFERENCE);
        this.jsx.use(SKIN_RESOURCES_DOCUMENT_REFERENCE);
        List<Object> contentBlocks = new ArrayList<Block>();
        if (content != null && !content.trim().isEmpty()) {
            List macroContent = this.macroUtils.getMacroContentXDOM(context.getCurrentMacroBlock(), context.getSyntax()).getChildren();
            contentBlocks = Collections.singletonList(new MetaDataBlock(macroContent, this.getNonGeneratedContentMetaData()));
        }
        return this.createTaskStructure(parameters, context, contentBlocks);
    }

    private List<Block> createTaskStructure(TaskMacroParameters parameters, MacroTransformationContext context, List<Block> contentBlocks) {
        GroupBlock ret = new GroupBlock();
        HashMap<String, String> blockParameters = new HashMap<String, String>();
        String className = "task-macro";
        className = parameters.getClassName() == null || parameters.getClassName().isEmpty() ? className : XMLUtils.escape((String)String.join((CharSequence)" ", className, parameters.getClassName()));
        blockParameters.put(HTML_CLASS, className);
        ret.setParameters(blockParameters);
        String checked = "";
        if (parameters.getStatus() != null && parameters.getStatus().equals("Done")) {
            checked = "checked";
        }
        EntityReference ownerDocRef = this.getOwnerDocument(context.getCurrentMacroBlock());
        EntityReference taskRef = this.taskReferenceUtils.resolve(parameters.getReference(), ownerDocRef);
        String taskId = this.taskReferenceUtils.serializeAsDocumentReference(taskRef, ownerDocRef);
        String htmlCheckbox = String.format("<input type=\"checkbox\" data-taskId=\"%s\" data-rawid=\"%s\" %s class=\"task-status\">", XMLUtils.escape((String)taskId), XMLUtils.escape((String)parameters.getReference()), checked);
        RawBlock checkBoxBlock = new RawBlock(htmlCheckbox, Syntax.HTML_5_0);
        GroupBlock taskInfoBlock = new GroupBlock(Collections.singletonMap(HTML_CLASS, "task-info"));
        taskInfoBlock.addChild((Block)new FormatBlock(Collections.singletonList(checkBoxBlock), Format.NONE));
        if (TaskMacroParameters.IdDisplay.TRUE.equals((Object)parameters.isIdDisplayed()) || parameters.isIdDisplayed() == null && this.taskConfiguration.isIdDisplayed()) {
            try {
                Task task = this.taskManager.getTask(taskRef);
                taskInfoBlock.addChild(this.taskBlockProcessor.createTaskLinkBlock(taskId, task.getNumber()));
            }
            catch (TaskException taskException) {
                // empty catch block
            }
        }
        ret.addChild((Block)taskInfoBlock);
        ret.addChild((Block)new GroupBlock(contentBlocks, Collections.singletonMap(HTML_CLASS, "task-content")));
        return Collections.singletonList(ret);
    }

    private EntityReference getOwnerDocument(MacroBlock block) {
        return this.macroDocumentReferenceResolver.resolve((Object)"", new Object[]{block});
    }
}

