/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal.job;

import com.xwiki.task.event.TaskRelativizedEvent;
import com.xwiki.task.event.TaskRelativizingEvent;
import com.xwiki.task.internal.TaskMacroReferenceMigrator;
import com.xwiki.task.job.TaskReferenceRelativizerJobRequest;
import com.xwiki.task.job.TaskReferenceRelativizerJobStatus;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.Job;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="taskmanager.relativizetaskreference")
public class TaskReferenceRelativizerJob
extends AbstractJob<TaskReferenceRelativizerJobRequest, TaskReferenceRelativizerJobStatus> {
    public static final String JOBTYPE = "taskmanager.relativizetaskreference";
    @Inject
    private QueryManager queryManager;
    @Inject
    private DocumentReferenceResolver<String> referenceResolver;
    @Inject
    private TaskMacroReferenceMigrator referenceMigrator;

    public String getType() {
        return JOBTYPE;
    }

    protected TaskReferenceRelativizerJobStatus createNewStatus(TaskReferenceRelativizerJobRequest request) {
        Job currentJob = this.jobContext.getCurrentJob();
        JobStatus currentJobStatus = currentJob != null ? currentJob.getStatus() : null;
        return new TaskReferenceRelativizerJobStatus(request, currentJobStatus, this.observationManager, this.loggerManager);
    }

    protected void runInternal() throws Exception {
        this.logger.info("Starting task reference relativizing job.");
        this.logger.info("Looking for pages that contain task macros.");
        String statement = "SELECT DISTINCT task.owner FROM Document AS doc, doc.object(TaskManager.TaskManagerClass) AS task WHERE task.owner <> ''";
        Query query = this.queryManager.createQuery(statement, "xwql");
        List results = query.execute();
        this.logger.info("Found [{}] pages that contain such macros.", (Object)results.size());
        List<DocumentReference> docRefs = results.stream().map(result -> this.referenceResolver.resolve(result, new Object[0])).collect(Collectors.toList());
        this.observationManager.notify((Event)new TaskRelativizingEvent(), (Object)this, docRefs);
        this.referenceMigrator.relativizeReference(docRefs);
        this.observationManager.notify((Event)new TaskRelativizedEvent(), (Object)this, docRefs);
        this.logger.info("Done.");
    }
}

