/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal.job;

import com.xwiki.task.TaskException;
import com.xwiki.task.TaskMissingDataManager;
import com.xwiki.task.job.TaskDataInferringJobRequest;
import com.xwiki.task.job.TaskDataInferringJobStatus;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.Job;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.DocumentReference;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Named(value="taskmanager.infertaskdata")
public class TaskDataInferringJob
extends AbstractJob<TaskDataInferringJobRequest, TaskDataInferringJobStatus> {
    public static final String JOBTYPE = "taskmanager.infertaskdata";
    @Inject
    private TaskMissingDataManager taskMissingDataManager;

    public String getType() {
        return JOBTYPE;
    }

    protected TaskDataInferringJobStatus createNewStatus(TaskDataInferringJobRequest request) {
        Job currentJob = this.jobContext.getCurrentJob();
        JobStatus currentJobStatus = currentJob != null ? currentJob.getStatus() : null;
        return new TaskDataInferringJobStatus(request, currentJobStatus, this.observationManager, this.loggerManager);
    }

    protected void runInternal() {
        this.logger.info("Starting data inferring job.");
        List owners = null;
        this.progressManager.pushLevelProgress(2, (Object)this);
        this.progressManager.startStep((Object)this);
        this.logger.info("Looking for pages that contain task macros with missing data.");
        try {
            owners = this.taskMissingDataManager.getMissingDataTaskOwners();
        }
        catch (TaskException taskException) {
            this.logger.warn("Failed to retrieve the pages holding tasks with incomplete data on the wiki [{}]. Cause: [{}].", ((TaskDataInferringJobRequest)this.request).getProperty("wiki"), (Object)ExceptionUtils.getRootCauseMessage((Throwable)taskException));
            return;
        }
        this.logger.info("Found [{}] pages that contain such macros.", (Object)owners.size());
        this.progressManager.startStep((Object)this);
        this.progressManager.pushLevelProgress(owners.size(), (Object)this);
        for (DocumentReference owner : owners) {
            this.progressManager.startStep((Object)this);
            try {
                this.taskMissingDataManager.inferMissingTaskData(owner);
                this.logger.info("Inferred data for the task macros inside [{}].", (Object)owner);
            }
            catch (TaskException e) {
                this.logger.warn("Failed to infer the missing data for the task macros in page [{}]. Cause [{}].", (Object)owner, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        this.logger.info("Done.");
    }
}

