/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.date.DateMacroConfiguration;
import com.xwiki.task.MacroUtils;
import com.xwiki.task.TaskException;
import com.xwiki.task.internal.MacroBlockFinder;
import com.xwiki.task.internal.TaskBlockProcessor;
import com.xwiki.task.internal.TaskReferenceUtils;
import com.xwiki.task.model.Task;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MacroBlockMatcher;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;

@Component(roles={TaskXDOMProcessor.class})
@Singleton
public class TaskXDOMProcessor {
    private static final String DATE_MACRO_ID = "date";
    private static final String MENTION_MACRO_ID = "mention";
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private TaskReferenceUtils taskReferenceUtils;
    @Inject
    private DateMacroConfiguration configuration;
    @Inject
    private Logger logger;
    @Inject
    private TaskBlockProcessor taskBlockProcessor;
    @Inject
    private MacroBlockFinder blockFinder;
    @Inject
    private MacroUtils macroUtils;

    public List<Task> extract(XDOM content, DocumentReference contentSource) {
        return this.extract(content, contentSource, false);
    }

    public List<Task> extract(XDOM content, DocumentReference contentSource, boolean onlyReferences) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        Syntax syntax = content.getMetaData().getMetaData().getOrDefault("syntax", Syntax.XWIKI_2_1);
        this.blockFinder.find(content, syntax, macro -> {
            if ("task".equals(macro.getId())) {
                String serializedRef = (String)macro.getParameters().get("reference");
                if (StringUtils.isEmpty((CharSequence)serializedRef)) {
                    return MacroBlockFinder.Lookup.SKIP;
                }
                DocumentReference taskRef = this.taskReferenceUtils.resolveAsDocumentReference(serializedRef, (EntityReference)contentSource);
                if (onlyReferences) {
                    tasks.add(new Task(taskRef));
                    return MacroBlockFinder.Lookup.CONTINUE;
                }
                Task task = this.initTask(syntax, contentSource, (MacroBlock)macro);
                if (task == null) {
                    return MacroBlockFinder.Lookup.SKIP;
                }
                task.setReference(taskRef);
                tasks.add(task);
            }
            return MacroBlockFinder.Lookup.CONTINUE;
        });
        return tasks;
    }

    public XDOM updateTaskMacroCall(DocumentReference documentReference, BaseObject taskObject, XDOM content, Syntax syntax) {
        DocumentReference taskDocRef = taskObject.getDocumentReference();
        SimpleDateFormat storageFormat = new SimpleDateFormat(this.configuration.getStorageDateFormat());
        this.blockFinder.find(content, syntax, macro -> {
            if ("task".equals(macro.getId())) {
                if (this.maybeUpdateTaskMacroCall(documentReference, taskObject, taskDocRef, content, storageFormat, (MacroBlock)macro)) {
                    return MacroBlockFinder.Lookup.BREAK;
                }
                return MacroBlockFinder.Lookup.CONTINUE;
            }
            return MacroBlockFinder.Lookup.CONTINUE;
        });
        return content;
    }

    public XDOM removeTaskMacroCall(DocumentReference taskReference, DocumentReference ownerReference, XDOM docContent, Syntax syntax) {
        this.blockFinder.find(docContent, syntax, macro -> {
            if ("task".equals(macro.getId())) {
                DocumentReference macroRef = this.taskReferenceUtils.resolveAsDocumentReference(macro.getParameters().getOrDefault("reference", ""), (EntityReference)ownerReference);
                if (macroRef.equals((Object)taskReference)) {
                    List siblings = macro.getParent().getChildren();
                    siblings.remove(macro);
                    return MacroBlockFinder.Lookup.BREAK;
                }
                return MacroBlockFinder.Lookup.SKIP;
            }
            return MacroBlockFinder.Lookup.CONTINUE;
        });
        return docContent;
    }

    private Task initTask(Syntax syntax, DocumentReference contentSource, MacroBlock macro) {
        Map macroParams = macro.getParameters();
        Task task = new Task();
        this.extractBasicProperties(macroParams, task);
        try {
            XDOM macroContent = this.macroUtils.getMacroContentXDOM(macro, syntax);
            task.setName(this.macroUtils.renderMacroContent(macroContent.getChildren(), Syntax.PLAIN_1_0));
            task.setAssignee(this.extractAssignedUser(macroContent));
            Date deadline = this.extractDeadlineDate(macroContent);
            task.setDuedate(deadline);
        }
        catch (ComponentLookupException | MacroExecutionException e) {
            this.logger.warn("Failed to extract the task with reference [{}] from the content of the page [{}]: [{}].", new Object[]{task.getReference(), contentSource, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            return null;
        }
        return task;
    }

    private boolean maybeUpdateTaskMacroCall(DocumentReference documentReference, BaseObject taskObject, DocumentReference taskDocRef, XDOM content, SimpleDateFormat storageFormat, MacroBlock macro) {
        DocumentReference taskRef = this.taskReferenceUtils.resolveAsDocumentReference(macro.getParameters().getOrDefault("reference", ""), (EntityReference)documentReference);
        if (taskRef.equals((Object)taskDocRef)) {
            this.setBasicMacroParameters(taskObject, storageFormat, macro);
            try {
                Syntax syntax = content.getMetaData().getMetaData().getOrDefault("syntax", Syntax.XWIKI_2_1);
                List<Block> newTaskContentBlocks = this.taskBlockProcessor.generateTaskContentBlocks(taskObject.getLargeStringValue("assignee"), taskObject.getDateValue("duedate"), taskObject.getStringValue("name"), storageFormat);
                String newContent = this.macroUtils.renderMacroContent(newTaskContentBlocks, syntax);
                this.macroUtils.updateMacroContent((Block)macro, newContent);
            }
            catch (TaskException | ComponentLookupException e) {
                this.logger.warn("Failed to update the task macro call for the task with reference [{}]: [{}].", (Object)taskDocRef, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            return true;
        }
        return false;
    }

    private void setBasicMacroParameters(BaseObject taskObject, SimpleDateFormat storageFormat, MacroBlock macro) {
        String taskStatus = taskObject.getStringValue("status");
        if (taskStatus.equals("Done")) {
            Date completeDate = taskObject.getDateValue("completeDate");
            macro.setParameter("completeDate", storageFormat.format(completeDate != null ? completeDate : new Date()));
        } else {
            taskObject.setDateValue("completeDate", null);
            macro.setParameter("completeDate", "");
        }
        Date createDate = taskObject.getDateValue("createDate");
        if (createDate == null) {
            createDate = new Date();
            taskObject.setDateValue("createDate", createDate);
        }
        macro.setParameter("createDate", storageFormat.format(createDate));
        macro.setParameter("status", taskObject.getStringValue("status"));
        macro.setParameter("reporter", taskObject.getLargeStringValue("reporter"));
    }

    private void extractBasicProperties(Map<String, String> macroParams, Task task) {
        block7: {
            SimpleDateFormat dateFormat;
            String strCompletedDate;
            String strCreateDate;
            String taskStatus;
            block6: {
                String reporter = macroParams.getOrDefault("reporter", "");
                if (!reporter.isEmpty()) {
                    task.setReporter(this.resolver.resolve((Object)reporter, new Object[0]));
                }
                taskStatus = macroParams.getOrDefault("status", "InProgress");
                task.setStatus(taskStatus);
                strCreateDate = macroParams.getOrDefault("createDate", "");
                strCompletedDate = macroParams.getOrDefault("completeDate", "");
                dateFormat = new SimpleDateFormat(this.configuration.getStorageDateFormat());
                try {
                    Date createDate = dateFormat.parse(strCreateDate);
                    task.setCreateDate(createDate);
                }
                catch (ParseException e) {
                    if (strCreateDate.isEmpty()) break block6;
                    this.logger.warn("Failed to parse the createDate macro parameter [{}]. Expected format is [{}]", (Object)strCreateDate, (Object)this.configuration.getStorageDateFormat());
                }
            }
            if (taskStatus.equals("Done")) {
                try {
                    Date completeDate = dateFormat.parse(strCompletedDate);
                    task.setCompleteDate(completeDate);
                }
                catch (ParseException e) {
                    if (strCompletedDate.isEmpty()) break block7;
                    this.logger.warn("Failed to parse the completeDate macro parameter [{}]. Expected format is [{}]", (Object)strCreateDate, (Object)this.configuration.getStorageDateFormat());
                }
            }
        }
    }

    private DocumentReference extractAssignedUser(XDOM taskContent) {
        MacroBlock macro = (MacroBlock)taskContent.getFirstBlock((BlockMatcher)new MacroBlockMatcher(MENTION_MACRO_ID), Block.Axes.DESCENDANT);
        if (macro == null) {
            return null;
        }
        return this.resolver.resolve((Object)((String)macro.getParameters().get("reference")), new Object[0]);
    }

    private Date extractDeadlineDate(XDOM taskContent) {
        Date deadline = null;
        MacroBlock macro = (MacroBlock)taskContent.getFirstBlock((BlockMatcher)new MacroBlockMatcher(DATE_MACRO_ID), Block.Axes.DESCENDANT);
        if (macro == null) {
            return deadline;
        }
        String dateValue = (String)macro.getParameters().get("value");
        try {
            String formatParam = (String)macro.getParameters().get("format");
            deadline = new SimpleDateFormat(formatParam != null && !formatParam.isEmpty() ? formatParam : this.configuration.getStorageDateFormat()).parse(dateValue);
        }
        catch (ParseException e) {
            this.logger.warn("Failed to parse the deadline date [{}] of the Task macro! Expected format is [{}]", (Object)dateValue, (Object)this.configuration.getStorageDateFormat());
        }
        return deadline;
    }
}

