/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.PageReference;
import org.xwiki.model.reference.PageReferenceResolver;

@Component(roles={TaskReferenceUtils.class})
@Singleton
public class TaskReferenceUtils {
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private PageReferenceResolver<String> pageReferenceResolver;
    @Inject
    private DocumentReferenceResolver<String> docStringResolver;
    @Inject
    private DocumentReferenceResolver<EntityReference> docRefResolver;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public EntityReference resolve(String representation, EntityReference relativeTo) {
        DocumentReference docRef = this.docStringResolver.resolve((Object)representation, new Object[]{relativeTo});
        try {
            if (!this.documentAccessBridge.exists(docRef)) {
                return this.pageReferenceResolver.resolve((Object)representation, new Object[]{relativeTo});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return docRef;
    }

    public String serializeAsDocumentReference(EntityReference reference, EntityReference relativeTo) {
        if (reference instanceof DocumentReference) {
            return (String)this.serializer.serialize(reference, new Object[]{relativeTo});
        }
        DocumentReference documentReference = this.docRefResolver.resolve((Object)reference, new Object[]{relativeTo});
        return (String)this.serializer.serialize((EntityReference)documentReference, new Object[]{relativeTo});
    }

    public DocumentReference resolveAsDocumentReference(String representation, EntityReference relativeTo) {
        EntityReference reference = this.resolve(representation, relativeTo);
        if (reference instanceof PageReference) {
            return this.docRefResolver.resolve((Object)reference, new Object[]{relativeTo});
        }
        return (DocumentReference)reference;
    }
}

