/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.task.event.TaskRelativizedEvent;
import com.xwiki.task.event.TaskRelativizingEvent;
import com.xwiki.task.internal.TaskMacroReferenceMigrator;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Singleton
@Named(value="TaskReferenceMigratorListener")
public class TaskReferenceMigratorListener
extends AbstractEventListener
implements Initializable {
    private static final LocalDocumentReference EXECUTED_DOC_FLAG = new LocalDocumentReference("TaskManager", "ReferenceRelitivizerExecuted");
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private Logger logger;
    @Inject
    private Provider<QueryManager> queryManagerProvider;
    @Inject
    private DocumentReferenceResolver<String> referenceResolver;
    @Inject
    private Provider<TaskMacroReferenceMigrator> referenceMigratorProvider;
    @Inject
    private Provider<ObservationManager> observationManagerProvider;

    public TaskReferenceMigratorListener() {
        super("TaskReferenceMigratorListener", Collections.emptyList());
    }

    public void onEvent(Event event, Object source, Object data) {
    }

    public void initialize() throws InitializationException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        if (context == null) {
            return;
        }
        DocumentReference flagDocRef = new DocumentReference(EXECUTED_DOC_FLAG, context.getWikiReference());
        try {
            if (context.getWiki().exists(flagDocRef, context)) {
                return;
            }
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to check whether [{}] exists or not. Cause: [{}].", (Object)EXECUTED_DOC_FLAG, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return;
        }
        try {
            this.logger.info("Starting task reference relativizing job.");
            String statement = "SELECT DISTINCT task.owner FROM Document AS doc, doc.object(TaskManager.TaskManagerClass) AS task WHERE task.owner <> ''";
            Query query = ((QueryManager)this.queryManagerProvider.get()).createQuery(statement, "xwql");
            List results = query.execute();
            this.logger.info("Found [{}] pages that contain task macros.", (Object)results.size());
            List<DocumentReference> docRefs = results.stream().map(result -> this.referenceResolver.resolve(result, new Object[0])).collect(Collectors.toList());
            ObservationManager observationManager = (ObservationManager)this.observationManagerProvider.get();
            observationManager.notify((Event)new TaskRelativizingEvent(), (Object)this, docRefs);
            ((TaskMacroReferenceMigrator)this.referenceMigratorProvider.get()).relativizeReference(docRefs);
            observationManager.notify((Event)new TaskRelativizedEvent(), (Object)this, docRefs);
            this.logger.info("Done.");
            XWikiDocument flagDoc = context.getWiki().getDocument(flagDocRef, context);
            flagDoc.setHidden(Boolean.valueOf(true));
            context.getWiki().saveDocument(flagDoc, context);
        }
        catch (XWikiException | QueryException e) {
            this.logger.warn("An error was encountered while trying to relitivize the references of the task macros. Cause: [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }
}

