/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentsDeletingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.refactoring.event.EntitiesRenamingEvent;
import org.xwiki.refactoring.internal.job.MoveJob;
import org.xwiki.refactoring.job.MoveRequest;
import org.xwiki.refactoring.job.question.EntitySelection;

@Component
@Singleton
@Named(value="TaskPageMovingEventListener")
public class TaskPageMovingEventListener
extends AbstractEventListener {
    private static final String MOVE_FLAG = "shouldMoveTasks";
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Logger logger;

    public TaskPageMovingEventListener() {
        super("TaskPageMovingEventListener", List.of(new EntitiesRenamingEvent(), new DocumentsDeletingEvent()));
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof EntitiesRenamingEvent) {
            this.handleMoveEvent((EntitiesRenamingEvent)event, (MoveJob)source, (MoveRequest)data);
        } else {
            this.handleDocumentsDeletingEvent(source, (Map)data);
        }
    }

    private void handleDocumentsDeletingEvent(Object source, Map<EntityReference, EntitySelection> concernedEntities) {
        if (!(source instanceof MoveJob)) {
            return;
        }
        MoveJob moveJob = (MoveJob)source;
        if (!((MoveRequest)moveJob.getRequest()).containsProperty(MOVE_FLAG)) {
            return;
        }
        Optional movedParentPage = ((MoveRequest)moveJob.getRequest()).getEntityReferences().stream().findFirst();
        if (movedParentPage.isEmpty()) {
            return;
        }
        this.logger.debug("Task owner [{}] moving in a non-deep job. Including the task pages under the Tasks subspace.", movedParentPage.get());
        SpaceReference tasksSpace = new SpaceReference("Tasks", ((EntityReference)movedParentPage.get()).getParent());
        for (Map.Entry<EntityReference, EntitySelection> entry : concernedEntities.entrySet()) {
            if (entry.getKey().hasParent((EntityReference)tasksSpace)) {
                entry.getValue().setSelected(true);
                continue;
            }
            entry.getValue().setSelected(false);
        }
        concernedEntities.get(movedParentPage.get()).setSelected(true);
        this.logger.debug("The following pages will be moved [{}].", concernedEntities.entrySet().stream().filter(e -> ((EntitySelection)e.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toList()));
    }

    private void handleMoveEvent(EntitiesRenamingEvent event, MoveJob source, MoveRequest moveRequest) {
        if (moveRequest.isDeep()) {
            this.logger.debug("Move Job is deep. Skipping.");
            return;
        }
        Optional movedParentPage = moveRequest.getEntityReferences().stream().findFirst();
        if (movedParentPage.isEmpty()) {
            return;
        }
        String statement = "from doc.object(TaskManager.TaskManagerClass) AS task WHERE task.owner like :page";
        try {
            this.logger.debug("Looking for task pages that have [{}] as owner.", movedParentPage.get());
            List childPages = this.queryManager.createQuery(statement, "xwql").bindValue("page", this.serializer.serialize((EntityReference)movedParentPage.get(), new Object[0])).setLimit(1).execute();
            if (!childPages.isEmpty()) {
                moveRequest.setProperty(MOVE_FLAG, (Object)true);
                moveRequest.setDeep(true);
                this.logger.debug("Found a task page. Set the job as deep.");
            } else {
                this.logger.debug("No task page has [{}] as owner.", movedParentPage.get());
            }
        }
        catch (QueryException e) {
            this.logger.warn("Failed to retrieve the task pages that have [{}] as owner. Cause: [{}].", movedParentPage.get(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }
}

