/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.task.TaskCounter;
import com.xwiki.task.TaskException;
import com.xwiki.task.internal.AbstractTaskEventListener;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.event.JobStartedEvent;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.event.DocumentCopyingEvent;
import org.xwiki.refactoring.event.DocumentRenamingEvent;
import org.xwiki.refactoring.job.AbstractCopyOrMoveRequest;

@Component
@Named(value="TaskPageCopiedOrMovedEventListener")
@Singleton
public class TaskPageCopiedOrMovedEventListener
extends AbstractEventListener {
    private static final String WEBHOME = "WebHome";
    private static final String TASKS = "Tasks";
    @Inject
    private ObservationContext observationContext;
    @Inject
    private TaskCounter taskCounter;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> serializer;
    private Object refactoringEvent;
    private JobStartedEvent jobStartedEvent;
    private EntityReference lastProcessedEntity;

    public TaskPageCopiedOrMovedEventListener() {
        super("TaskPageCopiedOrMovedEventListener", Collections.singletonList(new DocumentCreatedEvent()));
    }

    public void onEvent(Event event, Object source, Object data) {
        boolean changed = false;
        XWikiContext context = (XWikiContext)data;
        XWikiDocument document = ((XWikiDocument)source).clone();
        this.logger.debug("Processing [{}].", (Object)document.getDocumentReference());
        if (Objects.equals(this.lastProcessedEntity, document.getDocumentReference())) {
            this.logger.debug("Already processed [{}]. Returning.", (Object)document.getDocumentReference());
            return;
        }
        this.lastProcessedEntity = document.getDocumentReference();
        if (!this.observationContext.isIn(otherEvent -> {
            if (otherEvent instanceof DocumentCopyingEvent || otherEvent instanceof DocumentRenamingEvent) {
                this.refactoringEvent = otherEvent;
                return true;
            }
            return false;
        })) {
            this.logger.debug("Document [{}] was not created in a copying or renaming event. Returning.", (Object)document.getDocumentReference());
            this.refactoringEvent = null;
            return;
        }
        BaseObject taskObj = document.getXObject((EntityReference)AbstractTaskEventListener.TASK_CLASS_REFERENCE);
        if (taskObj == null) {
            this.logger.debug("Created document [{}] does not contain a task object.", (Object)document.getDocumentReference());
            return;
        }
        if (this.refactoringEvent instanceof DocumentCopyingEvent) {
            try {
                changed = true;
                int newNumber = this.taskCounter.getNextNumber();
                this.logger.debug("Task doc [{}] was copied. Changing the id of the copied instance from [{}] to [{}].", new Object[]{taskObj.getDocumentReference(), taskObj.getIntValue("number"), newNumber});
                taskObj.set("number", (Object)newNumber, context);
            }
            catch (TaskException e) {
                this.logger.warn("Failed to set a new id to the copied task document [{}]. Cause: [{}].", (Object)document.getDocumentReference(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        } else if (this.refactoringEvent instanceof DocumentRenamingEvent) {
            // empty if block
        }
        changed = this.maybeSetNewOwner(taskObj, context) || changed;
        this.maybeSave(changed, context, document);
    }

    private void maybeSave(boolean changed, XWikiContext context, XWikiDocument document) {
        if (changed) {
            try {
                context.getWiki().saveDocument(document, context);
            }
            catch (XWikiException e) {
                this.logger.warn("Failed to save the document.");
            }
        }
    }

    private boolean maybeSetNewOwner(BaseObject taskObj, XWikiContext context) {
        if (taskObj.getLargeStringValue("owner").isEmpty()) {
            this.logger.debug("Task doc [{}] doesn't have an owner.", (Object)taskObj.getDocumentReference());
            return false;
        }
        Optional<EntityReference> movedParentPage = this.getMovedOrCopiedEntity();
        if (!movedParentPage.isPresent()) {
            this.logger.debug("Task page [{}] was not moved as part of a move/copy job.", (Object)taskObj.getDocumentReference());
            return false;
        }
        if (this.isTaskPageMoved(taskObj, movedParentPage)) {
            this.logger.debug("Task page [{}] was created as a result of moving/copying either a task page or Tasks subspace [{}].", (Object)taskObj.getDocumentReference(), (Object)movedParentPage.get());
            return false;
        }
        try {
            DocumentReference ownerName;
            Object object = ownerName = taskObj.getDocumentReference().getName().equals(WEBHOME) ? taskObj.getDocumentReference().getParent() : taskObj.getDocumentReference();
            if (ownerName.getParent() != null && ownerName.getParent().getName().equals(TASKS)) {
                String newOwner = (String)this.serializer.serialize((EntityReference)new DocumentReference(WEBHOME, (SpaceReference)ownerName.getParent().getParent()), new Object[0]);
                this.logger.debug("Setting new owner for [{}] as [{}].", (Object)taskObj.getDocumentReference(), (Object)newOwner);
                taskObj.set("owner", (Object)newOwner, context);
                return true;
            }
            this.logger.debug("The moved/copied task page [{}] is not part of the Tasks subspace. The owner will not be updated.", (Object)taskObj.getDocumentReference());
        }
        catch (Exception e) {
            this.logger.error("Failed to set the new owner for the task page [{}].", (Object)taskObj.getDocumentReference(), (Object)e);
        }
        return false;
    }

    private boolean isTaskPageMoved(BaseObject taskObj, Optional<EntityReference> movedParentPage) {
        if (movedParentPage.get().equals((Object)taskObj.getDocumentReference())) {
            return true;
        }
        return movedParentPage.get().getName().equals(TASKS) || movedParentPage.get().getParent() != null && movedParentPage.get().getParent().getName().equals(TASKS);
    }

    private Optional<EntityReference> getMovedOrCopiedEntity() {
        if (!this.observationContext.isIn(otherEvent -> {
            if (otherEvent instanceof JobStartedEvent) {
                this.jobStartedEvent = (JobStartedEvent)otherEvent;
                return true;
            }
            return false;
        })) {
            this.jobStartedEvent = null;
            return Optional.empty();
        }
        if (!(this.jobStartedEvent.getRequest() instanceof AbstractCopyOrMoveRequest)) {
            return Optional.empty();
        }
        AbstractCopyOrMoveRequest copyOrMoveRequest = (AbstractCopyOrMoveRequest)this.jobStartedEvent.getRequest();
        return copyOrMoveRequest.getEntityReferences().stream().findFirst();
    }
}

