/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.task.TaskCounter;
import com.xwiki.task.TaskException;
import com.xwiki.task.internal.AbstractTaskEventListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.bridge.event.DocumentCreatingEvent;
import org.xwiki.bridge.event.DocumentDeletingEvent;
import org.xwiki.bridge.event.DocumentUpdatingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.Job;
import org.xwiki.job.JobGroupPath;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.observation.event.Event;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="TaskObjectUpdateEventListener")
@Singleton
public class TaskObjectUpdateEventListener
extends AbstractTaskEventListener {
    private static final LocalDocumentReference TEMPLATE_REFERENCE = new LocalDocumentReference("TaskManager", "TaskManagerTemplate");
    @Inject
    private TaskCounter taskCounter;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userRefResolver;

    public TaskObjectUpdateEventListener() {
        super(TaskObjectUpdateEventListener.class.getName(), Arrays.asList(new DocumentUpdatingEvent(), new DocumentCreatingEvent(), new DocumentDeletingEvent()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processEvent(XWikiDocument document, XWikiContext context, Event event, boolean inFoldEvent) {
        if (this.handleDeleteEvent(document, context, event)) {
            return;
        }
        BaseObject taskObj = document.getXObject((EntityReference)TASK_CLASS_REFERENCE);
        if (taskObj == null) {
            return;
        }
        this.maybeSetTaskNumber(context, taskObj);
        if (new LocalDocumentReference(document.getDocumentReference()).equals((Object)TEMPLATE_REFERENCE)) {
            return;
        }
        if (context.get((Object)"taskUpdating") != null) {
            return;
        }
        if (taskObj.getStringValue("owner").isEmpty()) {
            return;
        }
        String taskOwner = taskObj.getStringValue("owner");
        DocumentReference taskOwnerRef = this.resolver.resolve((Object)taskOwner, new Object[]{document.getDocumentReference()});
        try {
            XWikiDocument ownerDocument;
            context.put((Object)"taskUpdating", (Object)true);
            if (!taskOwner.isEmpty() && !(ownerDocument = context.getWiki().getDocument(taskOwnerRef, context).clone()).isNew()) {
                ownerDocument.setContent(this.taskXDOMProcessor.updateTaskMacroCall(taskOwnerRef, taskObj, ownerDocument.getXDOM(), ownerDocument.getSyntax()));
                UserReference currentUserReference = this.userRefResolver.resolve((Object)context.getUserReference(), new Object[0]);
                ownerDocument.getAuthors().setOriginalMetadataAuthor(currentUserReference);
                context.getWiki().saveDocument(ownerDocument, String.format("Task [%s] has been updated!", taskObj.getDocumentReference()), context);
            }
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to process the owner document of the task [{}]: [{}].", (Object)taskOwnerRef, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        finally {
            context.put((Object)"taskUpdating", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleDeleteEvent(XWikiDocument document, XWikiContext context, Event event) {
        if (event instanceof DocumentDeletingEvent) {
            if (context.get((Object)"taskUpdating") != null) {
                return true;
            }
            try {
                XWikiDocument actualDoc = context.getWiki().getDocument(document.getDocumentReference(), context);
                BaseObject object = actualDoc.getXObject((EntityReference)TASK_CLASS_REFERENCE);
                if (object == null || object.getStringValue("owner").isEmpty()) {
                    boolean bl = true;
                    return bl;
                }
                DocumentReference ownerDocumentReference = this.resolver.resolve((Object)object.getStringValue("owner"), new Object[]{document.getDocumentReference()});
                Job deletingJob = this.getDeletingJob(document);
                if (deletingJob != null && ((List)deletingJob.getRequest().getProperty("entityReferences", Collections.emptyList())).stream().anyMatch(e -> e instanceof EntityReference && this.isParentOrEqual((EntityReference)e, (EntityReference)ownerDocumentReference))) {
                    boolean bl = true;
                    return bl;
                }
                context.put((Object)"taskUpdating", (Object)true);
                XWikiDocument ownerDocument = context.getWiki().getDocument(ownerDocumentReference, context);
                ownerDocument.setContent(this.taskXDOMProcessor.removeTaskMacroCall(document.getDocumentReference(), ownerDocument.getDocumentReference(), ownerDocument.getXDOM(), ownerDocument.getSyntax()));
                context.getWiki().saveDocument(ownerDocument, String.format("Removed the task with the reference of [%s]", document.getDocumentReference()), context);
            }
            catch (XWikiException e2) {
                this.logger.warn("Failed to remove the macro call from the owner document of the task [{}]: [{}].", (Object)document.getDocumentReference(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e2));
            }
            finally {
                context.put((Object)"taskUpdating", null);
            }
            return true;
        }
        return false;
    }

    private Job getDeletingJob(XWikiDocument document) {
        ArrayList<String> deleteJobGroup = new ArrayList<String>();
        deleteJobGroup.add("refactoring");
        for (EntityReference entityReference : document.getDocumentReference().getLastSpaceReference().getReversedReferenceChain()) {
            deleteJobGroup.add(entityReference.getName());
            Job possibleJob = this.executor.getCurrentJob(new JobGroupPath(deleteJobGroup));
            if (possibleJob == null) continue;
            return possibleJob;
        }
        return null;
    }

    private boolean isParentOrEqual(EntityReference entity1, EntityReference entity2) {
        return entity1.equals((Object)entity2) || entity2.hasParent(entity1);
    }

    private void maybeSetTaskNumber(XWikiContext context, BaseObject taskObj) {
        if (taskObj.getIntValue("number", -1) == -1) {
            try {
                taskObj.set("number", (Object)this.taskCounter.getNextNumber(), context);
            }
            catch (TaskException e) {
                this.logger.warn("Failed to set a number to the task [{}]. Reason: [{}].", (Object)taskObj.getDocumentReference(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }
}

