/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.task.TaskException;
import com.xwiki.task.TaskManager;
import com.xwiki.task.internal.AbstractTaskEventListener;
import com.xwiki.task.model.Task;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentCreatingEvent;
import org.xwiki.bridge.event.DocumentDeletingEvent;
import org.xwiki.bridge.event.DocumentUpdatingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="com.xwiki.taskmanager.internal.TaskMacroUpdateEventListener")
@Singleton
public class TaskMacroUpdateEventListener
extends AbstractTaskEventListener {
    private static final String EXCEPTION_DOCUMENT_RETRIEVAL = "Could not retrieve the document [{}]. Cause:";
    @Inject
    private ContextualAuthorizationManager authorizationManager;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private TaskManager taskManager;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userRefResolver;
    private DocumentReference lastFoldDocumentReference;

    public TaskMacroUpdateEventListener() {
        super(TaskMacroUpdateEventListener.class.getName(), Arrays.asList(new DocumentUpdatingEvent(), new DocumentCreatingEvent(), new DocumentDeletingEvent()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processEvent(XWikiDocument document, XWikiContext context, Event event, boolean inFoldEvent) {
        if (document.getXObject((EntityReference)TASK_CLASS_REFERENCE) != null) {
            return;
        }
        if (context.get((Object)"taskUpdating") != null) {
            return;
        }
        if (this.maybeHandleFoldEvent(document, context, inFoldEvent)) {
            return;
        }
        if (event instanceof DocumentDeletingEvent) {
            try {
                context.put((Object)"taskUpdating", (Object)true);
                this.taskManager.deleteTasksByOwner(document.getDocumentReference());
            }
            catch (TaskException e) {
                this.logger.error("Failed to delete the tasks that have the current document as owner:", (Throwable)e);
            }
            finally {
                context.put((Object)"taskUpdating", null);
            }
            return;
        }
        this.updateTaskPages(document, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeHandleFoldEvent(XWikiDocument document, XWikiContext context, boolean inFoldEvent) {
        if (inFoldEvent) {
            if (this.lastFoldDocumentReference != null && !document.getDocumentReference().equals((Object)this.lastFoldDocumentReference)) {
                try {
                    this.updateTaskPages(context.getWiki().getDocument(this.lastFoldDocumentReference, context), context);
                }
                catch (XWikiException e) {
                    this.logger.warn(EXCEPTION_DOCUMENT_RETRIEVAL, (Object)this.lastFoldDocumentReference, (Object)e);
                }
                finally {
                    this.lastFoldDocumentReference = document.getDocumentReference();
                }
            } else {
                this.lastFoldDocumentReference = document.getDocumentReference();
            }
            return true;
        }
        return false;
    }

    private void updateTaskPages(XWikiDocument document, XWikiContext context) {
        XDOM documentContent = document.getXDOM();
        List<Task> tasks = this.taskXDOMProcessor.extract(documentContent, document.getDocumentReference());
        List<Task> previousDocTasks = Collections.emptyList();
        if (document.getOriginalDocument() != null) {
            XWikiDocument previousVersionDoc = document.getOriginalDocument();
            XDOM previousContent = previousVersionDoc.getXDOM();
            previousDocTasks = this.taskXDOMProcessor.extract(previousContent, document.getDocumentReference(), true);
            List currentTasksIds = tasks.stream().map(Task::getReference).collect(Collectors.toList());
            previousDocTasks.removeIf(task -> currentTasksIds.contains(task.getReference()));
        }
        if (!tasks.isEmpty() || !previousDocTasks.isEmpty()) {
            context.put((Object)"taskUpdating", (Object)true);
            this.deleteTaskPages(document, context, previousDocTasks);
            this.createOrUpdateTaskPages(document, context, tasks);
            context.put((Object)"taskUpdating", null);
        }
    }

    private void deleteTaskPages(XWikiDocument document, XWikiContext context, List<Task> previousDocTasks) {
        for (Task previousDocTask : previousDocTasks) {
            try {
                XWikiDocument taskDoc = context.getWiki().getDocument(previousDocTask.getReference(), context);
                BaseObject taskObj = taskDoc.getXObject((EntityReference)TASK_CLASS_REFERENCE);
                if (taskObj == null || !document.getDocumentReference().equals((Object)this.resolver.resolve((Object)taskObj.getLargeStringValue("owner"), new Object[]{previousDocTask.getReference()}))) continue;
                if (this.authorizationManager.hasAccess(Right.DELETE, (EntityReference)previousDocTask.getReference())) {
                    context.getWiki().deleteDocument(taskDoc, context);
                    continue;
                }
                if (this.authorizationManager.hasAccess(Right.EDIT, (EntityReference)previousDocTask.getReference())) {
                    taskObj.set("owner", (Object)"", context);
                    context.getWiki().saveDocument(taskDoc, context);
                    continue;
                }
                this.logger.warn("The task macro with id [{}] was removed but the associated page could not be deleted or modified because the current user does not have the rights to do so.", (Object)previousDocTask.getReference());
            }
            catch (XWikiException e) {
                this.logger.error("Failed to remove the Task Document with id [{}]:", (Object)previousDocTask.getReference(), (Object)e);
            }
        }
    }

    private void createOrUpdateTaskPages(XWikiDocument document, XWikiContext context, List<Task> tasks) {
        for (Task task : tasks) {
            DocumentReference taskReference = task.getReference();
            try {
                boolean docChanged;
                if (!this.isChildOfTasksSubspace((EntityReference)taskReference, document.getDocumentReference()) && !this.authorizationManager.hasAccess(Right.EDIT, (EntityReference)taskReference)) {
                    this.logger.warn("The user [{}] edited the macro with id [{}] but does not have edit rights over it's corresponding page.", (Object)context.getUserReference(), (Object)taskReference);
                    continue;
                }
                XWikiDocument taskDoc = context.getWiki().getDocument(taskReference, context).clone();
                BaseObject taskObj = taskDoc.getXObject((EntityReference)TASK_CLASS_REFERENCE, true, context);
                if (!taskDoc.isNew() && !document.getDocumentReference().equals((Object)this.resolver.resolve((Object)taskObj.getLargeStringValue("owner"), new Object[]{taskReference})) || !(docChanged = this.maybeUpdateTaskDoc(document, context, task, taskObj, taskDoc, taskReference))) continue;
                context.getWiki().saveDocument(taskDoc, "Task updated!", context);
            }
            catch (XWikiException e) {
                this.logger.error("Failed to retrieve the document that contains the Task Object with id [{}]:", (Object)taskReference, (Object)e);
            }
        }
    }

    private boolean maybeUpdateTaskDoc(XWikiDocument document, XWikiContext context, Task task, BaseObject taskObj, XWikiDocument taskDoc, DocumentReference taskReference) {
        boolean docChanged;
        BaseObject clonedObj = taskObj.clone();
        UserReference currentUser = this.userRefResolver.resolve((Object)context.getUserReference(), new Object[0]);
        taskDoc.getAuthors().setOriginalMetadataAuthor(currentUser);
        clonedObj.set("owner", this.serializer.serialize((EntityReference)document.getDocumentReference(), new Object[]{taskReference}), context);
        this.populateObjectWithMacroParams(context, task, clonedObj);
        boolean bl = docChanged = !clonedObj.getDiff((Object)taskObj, context).isEmpty();
        if (docChanged) {
            taskDoc.setXObject(taskObj.getNumber(), clonedObj);
        }
        if (taskDoc.isNew()) {
            taskDoc.setHidden(Boolean.valueOf(true));
            taskDoc.getAuthors().setCreator(currentUser);
            taskDoc.getAuthors().setEffectiveMetadataAuthor(currentUser);
        }
        return docChanged;
    }

    private boolean isChildOfTasksSubspace(EntityReference possibleChild, DocumentReference possibleParent) {
        SpaceReference expectedParent = new SpaceReference("Tasks", possibleParent.getLastSpaceReference());
        return possibleChild.hasParent((EntityReference)expectedParent);
    }

    private void populateObjectWithMacroParams(XWikiContext context, Task task, BaseObject object) {
        object.set("name", (Object)task.getName(), context);
        object.set("reporter", this.serializer.serialize((EntityReference)task.getReporter(), new Object[0]), context);
        object.set("status", (Object)task.getStatus(), context);
        object.set("createDate", (Object)task.getCreateDate(), context);
        object.set("assignee", this.serializer.serialize((EntityReference)task.getAssignee(), new Object[0]), context);
        object.set("duedate", (Object)task.getDueDate(), context);
        object.set("completeDate", (Object)task.getCompleteDate(), context);
    }
}

