/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.task.internal.MacroBlockFinder;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.PageReferenceResolver;
import org.xwiki.rendering.block.XDOM;

@Component(roles={TaskMacroReferenceMigrator.class})
@Singleton
public class TaskMacroReferenceMigrator {
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private MacroBlockFinder blockFinder;
    @Inject
    @Named(value="supercompact")
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private PageReferenceResolver<EntityReference> pageReferenceResolver;
    @Inject
    private Logger logger;

    public void relativizeReference(List<DocumentReference> referenceList) {
        for (DocumentReference documentReference : referenceList) {
            String compactRef = (String)this.serializer.serialize((EntityReference)this.pageReferenceResolver.resolve((Object)documentReference, new Object[0]), new Object[0]) + "/";
            try {
                this.logger.info("Searching for tasks inside [{}].", (Object)compactRef);
                XWikiContext context = (XWikiContext)this.contextProvider.get();
                XWikiDocument document = context.getWiki().getDocument(documentReference, context);
                XDOM updatedXDOM = this.blockFinder.find(document.getXDOM(), document.getSyntax(), macroBlock -> {
                    if ("task".equals(macroBlock.getId()) && macroBlock.getParameters().containsKey("reference")) {
                        String referenceParam = macroBlock.getParameter("reference");
                        if (referenceParam.startsWith(compactRef)) {
                            referenceParam = referenceParam.substring(compactRef.length() - 1);
                            this.logger.info("Replaced the reference of a task macro from [{}] to [{}].", (Object)macroBlock.getParameter("reference"), (Object)referenceParam);
                            macroBlock.setParameter("reference", referenceParam);
                        }
                        return MacroBlockFinder.Lookup.SKIP;
                    }
                    return MacroBlockFinder.Lookup.CONTINUE;
                });
                if (document.getXDOM().equals((Object)updatedXDOM)) continue;
                DocumentReference currentUser = context.getUserReference();
                context.setUserReference(document.getAuthorReference());
                document.setContent(updatedXDOM);
                context.getWiki().saveDocument(document, "Updated the reference of the task macros to be relative.", true, context);
                context.setUserReference(currentUser);
            }
            catch (XWikiException e) {
                this.logger.warn("Failed to retrieve the document [{}]. Cause [{}].", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }
}

