/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.rcs.XWikiRCSNodeInfo;
import com.xwiki.date.DateMacroConfiguration;
import com.xwiki.task.TaskException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.suigeneris.jrcs.diff.DifferentiationFailedException;
import org.suigeneris.jrcs.diff.delta.AddDelta;
import org.suigeneris.jrcs.diff.delta.Chunk;
import org.suigeneris.jrcs.diff.delta.Delta;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MacroBlockMatcher;

@Component(roles={TaskDatesInitializer.class})
@Singleton
public class TaskDatesInitializer {
    private static final String TASK_PATTERN_STRING = "\\{\\{task[^}]*/?}}";
    private static final String TASK_PARAMETERS_PATTERN_STRING = "(\\w+)=['\"]([^'\"]*)['\"]";
    private final Pattern taskPattern = Pattern.compile("\\{\\{task[^}]*/?}}");
    private final Pattern paramPattern = Pattern.compile("(\\w+)=['\"]([^'\"]*)['\"]");
    @Inject
    private DateMacroConfiguration configuration;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private DocumentRevisionProvider revisionProvider;
    @Inject
    private Logger logger;

    public boolean doesDocumentContainIncompleteTasks(XDOM content) {
        List taskMacros = content.getBlocks((BlockMatcher)new MacroBlockMatcher("task"), Block.Axes.DESCENDANT_OR_SELF);
        return taskMacros.stream().anyMatch(macro -> macro.getParameter("reporter") == null || "".equals(macro.getParameter("reporter")));
    }

    public boolean processDocument(XWikiDocument ownerDoc, XDOM content, XWikiContext context) throws TaskException {
        Version[] versions;
        HashMap<String, Block> createDateTasks = new HashMap<String, Block>();
        HashMap<String, Block> completeDateTasks = new HashMap<String, Block>();
        try {
            content.getBlocks((BlockMatcher)new MacroBlockMatcher("task"), Block.Axes.DESCENDANT).forEach(task -> this.separateProcessableTasks((Block)task, (Map<String, Block>)createDateTasks, (Map<String, Block>)completeDateTasks));
            versions = ownerDoc.getRevisions(context);
        }
        catch (XWikiException e) {
            throw new TaskException(String.format("Could not extract the tasks from the content of [%s].", ownerDoc.getDocumentReference()), (Throwable)e);
        }
        SimpleDateFormat storageFormat = new SimpleDateFormat(this.configuration.getStorageDateFormat());
        if (createDateTasks.isEmpty() && completeDateTasks.isEmpty()) {
            return false;
        }
        int foundTasks = createDateTasks.size() + completeDateTasks.size();
        this.extractFromVersion1OfDoc(versions, createDateTasks, completeDateTasks, ownerDoc, storageFormat);
        this.compareVersionsAndExtract(context, versions, createDateTasks, completeDateTasks, ownerDoc, storageFormat);
        return foundTasks != createDateTasks.size() + completeDateTasks.size();
    }

    private void compareVersionsAndExtract(XWikiContext context, Version[] versions, Map<String, Block> createDateTasks, Map<String, Block> completeDateTasks, XWikiDocument ownerDoc, SimpleDateFormat storageFormat) {
        int j = versions.length - 1;
        for (int i = versions.length - 2; !(i < 0 || createDateTasks.isEmpty() && completeDateTasks.isEmpty()); --i) {
            try {
                List deltas = ownerDoc.getContentDiff(versions[i].toString(), versions[j].toString(), context);
                XWikiRCSNodeInfo versionInfo = ownerDoc.getRevisionInfo(versions[j].toString(), context);
                for (Delta delta : deltas) {
                    this.inferDateFromContent(createDateTasks, completeDateTasks, storageFormat, versionInfo.getDate(), versionInfo.getAuthor(), delta);
                }
                j = i;
                continue;
            }
            catch (XWikiException | DifferentiationFailedException e) {
                this.logger.warn("Failed to compare the versions [{}] and [{}] of the document [{}]. Cause [{}].", new Object[]{versions[j], versions[i], ownerDoc.getDocumentReference(), ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
        }
    }

    private void extractFromVersion1OfDoc(Version[] versions, Map<String, Block> createDateTasks, Map<String, Block> completeDateTasks, XWikiDocument ownerDoc, SimpleDateFormat storageFormat) {
        try {
            XWikiDocument v1Doc = this.revisionProvider.getRevision(ownerDoc, versions[0].toString());
            String author = (String)this.serializer.serialize((EntityReference)v1Doc.getAuthorReference(), new Object[0]);
            this.inferDateFromContent(createDateTasks, completeDateTasks, storageFormat, v1Doc.getDate(), author, (Delta)new AddDelta(0, new Chunk((Object[])new String[]{v1Doc.getContent()}, 0, 1)));
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to infer the completeDate/createDate of the tasks from the version [{}] of the document [{}].", (Object)versions[0].toString(), (Object)ownerDoc.getDocumentReference());
        }
    }

    private void inferDateFromContent(Map<String, Block> createDateBlocks, Map<String, Block> completeDateBlocks, SimpleDateFormat storageFormat, Date date, String author, Delta delta) {
        Matcher matcher = this.taskPattern.matcher(delta.getRevised().toString());
        while (matcher.find()) {
            String task = matcher.group();
            Matcher paramMatcher = this.paramPattern.matcher(task);
            String taskReference = "";
            String status = "";
            while (paramMatcher.find()) {
                if (paramMatcher.group(1).equals("reference")) {
                    taskReference = paramMatcher.group(2);
                    continue;
                }
                if (!paramMatcher.group(1).equals("status")) continue;
                status = paramMatcher.group(2);
            }
            if (delta instanceof AddDelta) {
                if (createDateBlocks.containsKey(taskReference)) {
                    createDateBlocks.get(taskReference).setParameter("reporter", author);
                }
                this.setParameterAndRemoveIfPresent(createDateBlocks, "createDate", storageFormat.format(date), taskReference);
            }
            if (!"Done".equals(status)) continue;
            this.setParameterAndRemoveIfPresent(completeDateBlocks, "completeDate", storageFormat.format(date), taskReference);
        }
    }

    private void setParameterAndRemoveIfPresent(Map<String, Block> map, String paramKey, String paramVal, String reference) {
        if (map.containsKey(reference)) {
            map.get(reference).setParameter(paramKey, paramVal);
            map.remove(reference);
        }
    }

    private void separateProcessableTasks(Block macroBlock, Map<String, Block> noCreateDateTasks, Map<String, Block> noCompleteDateTasks) {
        String reference = macroBlock.getParameter("reference");
        if (macroBlock.getParameter("createDate") == null) {
            noCreateDateTasks.put(reference, macroBlock);
        }
        if (macroBlock.getParameter("completeDate") == null && "Done".equals(macroBlock.getParameter("status"))) {
            noCompleteDateTasks.put(reference, macroBlock);
        }
    }
}

