/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xwiki.task.MacroUtils;
import com.xwiki.task.TaskException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.SpecialSymbolBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;

@Component(roles={TaskBlockProcessor.class})
@Singleton
public class TaskBlockProcessor {
    private static final String DATE = "date";
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;
    @Inject
    private MacroUtils macroUtils;

    public Block createTaskLinkBlock(String reference, int taskNumber) {
        return this.createTaskLinkBlock(reference, taskNumber, ResourceType.DOCUMENT);
    }

    public Block createTaskLinkBlock(String reference, int taskNumber, ResourceType resourceType) {
        return new LinkBlock(Arrays.asList(new SpecialSymbolBlock('#'), new WordBlock(String.valueOf(taskNumber))), new ResourceReference(reference, resourceType), false);
    }

    public List<Block> generateTaskContentBlocks(String assignee, Date duedate, String text, SimpleDateFormat storageFormat) throws TaskException {
        XDOM newTaskContentXDOM = null;
        try {
            newTaskContentXDOM = this.macroUtils.getMacroContentXDOM(new MacroBlock("temporaryMacro", new HashMap(), text == null ? "" : text, false), Syntax.PLAIN_1_0);
        }
        catch (MacroExecutionException e) {
            throw new TaskException(String.format("Failed to generate the XDOM for the given content [%s].", text), (Throwable)e);
        }
        Block insertionPoint = newTaskContentXDOM.getFirstBlock((BlockMatcher)new ClassBlockMatcher(ParagraphBlock.class), Block.Axes.DESCENDANT_OR_SELF);
        if (insertionPoint == null) {
            insertionPoint = newTaskContentXDOM;
        }
        if (!StringUtils.isEmpty((CharSequence)assignee)) {
            HashMap<String, Object> mentionParams = new HashMap<String, Object>();
            mentionParams.put("style", "FULL_NAME");
            mentionParams.put("reference", assignee);
            mentionParams.put("anchor", assignee.replace('.', '-') + "-" + RandomStringUtils.random((int)5, (boolean)true, (boolean)false));
            MacroBlock mentionBlock = new MacroBlock("mention", mentionParams, true);
            insertionPoint.addChild((Block)mentionBlock);
        }
        if (duedate != null) {
            HashMap<String, String> dateParams = new HashMap<String, String>();
            dateParams.put("value", storageFormat.format(duedate));
            MacroBlock dateBlock = new MacroBlock(DATE, dateParams, true);
            insertionPoint.addChild((Block)dateBlock);
        }
        return newTaskContentXDOM.getChildren();
    }
}

