/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xpn.xwiki.internal.model.reference.CompactStringEntityReferenceSerializer;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.SymbolScheme;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.PageReference;

@Component
@Named(value="supercompact")
@Singleton
public class SuperCompactReferenceSerializer
extends CompactStringEntityReferenceSerializer {
    private static final String DELIMITER_PAGE = "/";
    @Inject
    private SymbolScheme scheme;

    public String serialize(EntityReference reference, Object ... parameters) {
        if (!(reference instanceof PageReference) || parameters.length == 0 || !(parameters[0] instanceof EntityReference)) {
            return super.serialize(reference, parameters);
        }
        EntityReference relativeToRef = (EntityReference)parameters[0];
        if (relativeToRef.getName().equals("WebHome")) {
            relativeToRef = relativeToRef.getParent();
        }
        if (!(relativeToRef instanceof PageReference)) {
            relativeToRef = this.convertToPageReference(relativeToRef);
        }
        try {
            String serialization = super.serialize(reference.removeParent(relativeToRef), parameters);
            String pageDelimiter = this.getPageDelimiter();
            return serialization.startsWith(pageDelimiter) ? serialization : pageDelimiter.concat(serialization);
        }
        catch (IllegalArgumentException e) {
            return super.serialize(reference, parameters);
        }
    }

    private String getPageDelimiter() {
        if (this.scheme == null) {
            return DELIMITER_PAGE;
        }
        if (!this.scheme.getSeparatorSymbols().containsKey(EntityType.PAGE)) {
            return DELIMITER_PAGE;
        }
        if (!((Map)this.scheme.getSeparatorSymbols().get(EntityType.PAGE)).containsKey(EntityType.PAGE)) {
            return DELIMITER_PAGE;
        }
        return ((Character)((Map)this.scheme.getSeparatorSymbols().get(EntityType.PAGE)).get(EntityType.PAGE)).toString();
    }

    private EntityReference convertToPageReference(EntityReference reference) {
        EntityReference pageReference = null;
        for (EntityReference refInChain : reference.getReversedReferenceChain()) {
            if (refInChain.getType().equals((Object)EntityType.WIKI)) {
                pageReference = refInChain;
                continue;
            }
            pageReference = new EntityReference(refInChain.getName(), EntityType.PAGE, pageReference);
        }
        return pageReference;
    }
}

