/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xwiki.task.MacroUtils;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.syntax.Syntax;

@Component(roles={MacroBlockFinder.class})
@Singleton
public class MacroBlockFinder {
    @Inject
    private MacroUtils macroUtils;
    @Inject
    private Logger logger;

    public XDOM find(XDOM content, Syntax syntax, Function<MacroBlock, Lookup> function) {
        MacroBlock macro;
        Lookup lookup;
        List macros = content.getBlocks((BlockMatcher)new ClassBlockMatcher(MacroBlock.class), Block.Axes.DESCENDANT);
        Iterator iterator = macros.iterator();
        while (iterator.hasNext() && !(lookup = function.apply(macro = (MacroBlock)iterator.next())).equals((Object)Lookup.BREAK)) {
            if (lookup.equals((Object)Lookup.SKIP) || macro.getContent() == null || macro.getContent().isEmpty() || !this.macroUtils.isMacroContentParsable(macro.getId())) continue;
            try {
                XDOM updatedContent = this.find(this.macroUtils.getMacroContentXDOM(macro, syntax), syntax, function);
                this.macroUtils.updateMacroContent((Block)macro, this.macroUtils.renderMacroContent(updatedContent.getChildren(), syntax));
            }
            catch (ComponentLookupException | MacroExecutionException e) {
                this.logger.warn("Failed to update the content of the macro identified by [{}]. Cause: [{}]", (Object)macro.getId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return content;
    }

    public static enum Lookup {
        BREAK,
        SKIP,
        CONTINUE;

    }
}

