/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xwiki.task.TaskException;
import com.xwiki.task.TaskReferenceGenerator;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.SpaceReference;

@Component
@Singleton
public class DefaultTaskReferenceGenerator
implements TaskReferenceGenerator {
    private static final String TASK_PAGE_NAME_PREFIX = "Task_";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    private final Map<SpaceReference, Integer> nameOccurences = new HashMap<SpaceReference, Integer>();

    public synchronized DocumentReference generate(DocumentReference parent) throws TaskException {
        try {
            SpaceReference parentSpaceRef = parent.getLastSpaceReference();
            return this.getUniqueName(parentSpaceRef);
        }
        catch (Exception e) {
            throw new TaskException(String.format("Failed to generate an unique name for the parent [%s].", parent), (Throwable)e);
        }
    }

    private DocumentReference getUniqueName(SpaceReference spaceRef) throws Exception {
        int i = this.nameOccurences.getOrDefault(spaceRef, 1);
        String pageName = TASK_PAGE_NAME_PREFIX + i;
        DocumentReference docRef = this.composeDocReference(pageName, spaceRef, false);
        DocumentReference nonTerminalDocRef = this.composeDocReference(pageName, spaceRef, true);
        while (this.documentAccessBridge.exists(docRef) || this.documentAccessBridge.exists(nonTerminalDocRef)) {
            pageName = TASK_PAGE_NAME_PREFIX + ++i;
            docRef = this.composeDocReference(pageName, spaceRef, false);
            nonTerminalDocRef = this.composeDocReference(pageName, spaceRef, true);
            this.nameOccurences.put(spaceRef, i);
        }
        this.nameOccurences.put(spaceRef, ++i);
        return docRef;
    }

    private DocumentReference composeDocReference(String pageRef, SpaceReference spaceReference, boolean terminal) {
        if (!terminal) {
            return new DocumentReference(pageRef, spaceReference);
        }
        SpaceReference spRef = new SpaceReference(pageRef, spaceReference);
        return new DocumentReference("WebHome", spRef);
    }
}

