/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xwiki.task.TaskException;
import com.xwiki.task.TaskManager;
import com.xwiki.task.model.Task;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Singleton
public class DefaultTaskManager
implements TaskManager {
    private static final LocalDocumentReference TASK_CLASS_REFERENCE = new LocalDocumentReference(Collections.singletonList("TaskManager"), "TaskManagerClass");
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private QueryManager queryManager;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactserializer;

    public Task getTask(DocumentReference reference) throws TaskException {
        return this.getTask((EntityReference)reference);
    }

    public Task getTask(EntityReference reference) throws TaskException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        try {
            XWikiDocument doc = context.getWiki().getDocument(reference, context);
            BaseObject obj = doc.getXObject((EntityReference)TASK_CLASS_REFERENCE);
            if (obj == null) {
                throw new TaskException(String.format("The page [%s] does not have a Task Object.", reference));
            }
            return this.getTaskFromXObject(obj);
        }
        catch (XWikiException e) {
            throw new TaskException(String.format("Failed to retrieve the task from the page [%s]", reference));
        }
    }

    public Task getTask(int id) throws TaskException {
        try {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            String statement = ", BaseObject as taskObj, IntegerProperty as idProp WHERE taskObj.name = doc.fullName AND doc.fullName != 'TaskManager.TaskManagerTemplate' AND taskObj.className = 'TaskManager.TaskManagerClass' AND taskObj.id = idProp.id.id AND idProp.id.name = 'number' AND idProp.value = :id";
            List results = this.queryManager.createQuery(statement, "hql").setWiki(context.getWikiId()).bindValue("id", (Object)id).execute();
            if (results.size() > 0) {
                DocumentReference documentReference = this.resolver.resolve((Object)((String)results.get(0)), new Object[]{context.getWikiReference()});
                XWikiDocument document = context.getWiki().getDocument(documentReference, context);
                BaseObject taskObject = document.getXObject((EntityReference)TASK_CLASS_REFERENCE);
                if (taskObject == null) {
                    throw new TaskException(String.format("Could not retrieve the task object [%s] associated with the task with id [%d]", documentReference, id));
                }
                return this.getTaskFromXObject(taskObject);
            }
            throw new TaskException(String.format("There is no task with the id [%d].", id));
        }
        catch (XWikiException | QueryException e) {
            throw new TaskException(String.format("Failed to retrieve the task with id [%s].", id), e);
        }
    }

    public void deleteTasksByOwner(DocumentReference documentReference) throws TaskException {
        try {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            String statement = "FROM doc.object(TaskManager.TaskManagerClass) as task WHERE task.owner = :absoluteOwnerRef OR task.owner = :compactOwnerRef OR (task.owner = :relativeOwnerRef AND doc.space = :ownerSpaceRef)";
            Query query = this.queryManager.createQuery(statement, "xwql");
            query.bindValue("absoluteOwnerRef", this.serializer.serialize((EntityReference)documentReference, new Object[0])).bindValue("compactOwnerRef", this.compactserializer.serialize((EntityReference)documentReference, new Object[0])).bindValue("relativeOwnerRef", (Object)documentReference.getName()).bindValue("ownerSpaceRef", this.compactserializer.serialize((EntityReference)documentReference.getLastSpaceReference(), new Object[0]));
            List results = query.execute();
            for (String result : results) {
                DocumentReference taskRef = this.resolver.resolve((Object)result, new Object[]{context.getWikiReference()});
                XWikiDocument document = context.getWiki().getDocument(taskRef, context);
                BaseObject taskObject = document.getXObject((EntityReference)TASK_CLASS_REFERENCE);
                if (taskObject == null || !this.resolver.resolve((Object)taskObject.getLargeStringValue("owner"), new Object[]{taskRef}).equals((Object)documentReference)) continue;
                context.getWiki().deleteDocument(document, context);
            }
        }
        catch (XWikiException | QueryException e) {
            throw new TaskException(String.format("Failed to delete the task documents that had [%s] as owner.", documentReference), e);
        }
    }

    private Task getTaskFromXObject(BaseObject obj) {
        Task task = new Task();
        task.setReference(obj.getDocumentReference());
        task.setName(obj.getStringValue("name"));
        task.setNumber(obj.getIntValue("number"));
        task.setOwner(this.resolver.resolve((Object)obj.getLargeStringValue("owner"), new Object[]{obj.getDocumentReference()}));
        String assignee = obj.getLargeStringValue("assignee");
        task.setAssignee(assignee.isEmpty() ? null : this.resolver.resolve((Object)assignee, new Object[0]));
        task.setStatus(obj.getStringValue("status"));
        task.setReporter(this.resolver.resolve((Object)obj.getLargeStringValue("reporter"), new Object[0]));
        task.setDuedate(obj.getDateValue("duedate"));
        task.setCreateDate(obj.getDateValue("createDate"));
        task.setCompleteDate(obj.getDateValue("completeDate"));
        return task;
    }
}

