/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xwiki.task.TaskCounter;
import com.xwiki.task.TaskException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Singleton
public class DefaultTaskCounter
implements TaskCounter {
    @Inject
    private QueryManager queryManager;
    @Inject
    private ModelContext modelContext;
    private final Map<String, Integer> counterMap = new HashMap<String, Integer>();

    public synchronized int getNextNumber() throws TaskException {
        String statement = "select max(taskObject.number) from Document doc, doc.object(TaskManager.TaskManagerClass) as taskObject where taskObject.number is not null";
        try {
            EntityReference reference = this.modelContext.getCurrentEntityReference();
            if (reference == null) {
                throw new TaskException("There is no object placed in the model context.");
            }
            String wiki = reference.getName();
            List result = this.queryManager.createQuery(statement, "xwql").setWiki(wiki).execute();
            int number = 0;
            if (result.size() > 0 && result.get(0) != null) {
                number = (Integer)result.get(0);
            }
            this.counterMap.put(wiki, Integer.max(number, this.counterMap.getOrDefault(wiki, -1)) + 1);
            return this.counterMap.get(wiki);
        }
        catch (TaskException | QueryException e) {
            throw new TaskException("Failed to get the next valid number.", e);
        }
    }
}

