/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xwiki.task.MacroUtils;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.AbstractMacroBlock;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Singleton
public class DefaultMacroUtils
implements MacroUtils {
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;
    @Inject
    private MacroContentParser contentParser;
    @Inject
    private MacroManager macroManager;

    public void updateMacroContent(Block macro, String newContent) {
        if (macro.getParent() == null) {
            return;
        }
        List siblings = macro.getParent().getChildren();
        int macroIndex = -1;
        for (int i = 0; i < siblings.size(); ++i) {
            if (!(siblings.get(i) instanceof AbstractMacroBlock) || !macro.equals(siblings.get(i))) continue;
            macroIndex = i;
            break;
        }
        if (macroIndex == -1) {
            return;
        }
        siblings.remove(macroIndex);
        MacroBlock newMacroBlock = new MacroBlock(((MacroBlock)macro).getId(), macro.getParameters(), newContent, ((MacroBlock)macro).isInline());
        siblings.add(macroIndex, newMacroBlock);
    }

    public XDOM getMacroContentXDOM(MacroBlock macroBlock, Syntax syntax) throws MacroExecutionException {
        MacroTransformationContext macroContext = new MacroTransformationContext();
        macroContext.setCurrentMacroBlock(macroBlock);
        macroContext.setSyntax(syntax);
        return this.contentParser.parse(macroBlock.getContent(), macroContext, true, false);
    }

    public String renderMacroContent(List<Block> contentBlocks, Syntax syntax) throws ComponentLookupException {
        BlockRenderer renderer = (BlockRenderer)this.contextComponentManager.getInstance(BlockRenderer.class, syntax.toIdString());
        DefaultWikiPrinter printer = new DefaultWikiPrinter(new StringBuffer());
        renderer.render(contentBlocks, (WikiPrinter)printer);
        return printer.toString();
    }

    public boolean isMacroContentParsable(String macroId) {
        try {
            Macro macro = this.macroManager.getMacro(new MacroId(macroId));
            ContentDescriptor contentDescriptor = macro.getDescriptor().getContentDescriptor();
            return contentDescriptor != null && Block.LIST_BLOCK_TYPE.equals(contentDescriptor.getType());
        }
        catch (MacroLookupException e) {
            return false;
        }
    }
}

