/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import java.util.Collections;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSaveException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="com.xwiki.task.internal.DateFormatMigrationListener")
@Singleton
public class DateFormatMigrationListener
extends AbstractEventListener
implements Initializable {
    public static final String ROLE_HINT = "com.xwiki.task.internal.DateFormatMigrationListener";
    private static final String DATE_STORAGE_FORMAT_KEY = "storageDateFormat";
    private static final String DATE_DISPLAY_FORMAT_KEY = "displayDateFormat";
    @Inject
    @Named(value="taskmanager")
    private Provider<ConfigurationSource> configurationSourceProvider;
    @Inject
    @Named(value="datemacro")
    private Provider<ConfigurationSource> dateMacroConfigurationSourceProvider;
    @Inject
    private Logger logger;

    public DateFormatMigrationListener() {
        super(ROLE_HINT, Collections.emptyList());
    }

    public void initialize() throws InitializationException {
        try {
            this.maybeReplaceDateFormat();
        }
        catch (Exception e) {
            this.logger.warn("Failed to migrate the date configuration. Cause: [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public void onEvent(Event event, Object source, Object data) {
    }

    private void maybeReplaceDateFormat() throws ConfigurationSaveException {
        HashMap<String, String> properties = new HashMap<String, String>();
        ConfigurationSource configurationSource = (ConfigurationSource)this.configurationSourceProvider.get();
        ConfigurationSource dateMacroConfigurationSource = (ConfigurationSource)this.dateMacroConfigurationSourceProvider.get();
        String storageDateFormatProperty = (String)configurationSource.getProperty(DATE_STORAGE_FORMAT_KEY);
        String displayDateFormatProperty = (String)configurationSource.getProperty(DATE_DISPLAY_FORMAT_KEY);
        if (storageDateFormatProperty != null) {
            properties.put(DATE_STORAGE_FORMAT_KEY, storageDateFormatProperty);
        }
        if (displayDateFormatProperty != null) {
            properties.put(DATE_DISPLAY_FORMAT_KEY, displayDateFormatProperty);
        }
        if (!properties.isEmpty()) {
            dateMacroConfigurationSource.setProperties(properties);
            this.clearOldDateFormatConfiguration(configurationSource);
        }
    }

    private void clearOldDateFormatConfiguration(ConfigurationSource configurationSource) throws ConfigurationSaveException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(DATE_STORAGE_FORMAT_KEY, null);
        properties.put(DATE_DISPLAY_FORMAT_KEY, null);
        configurationSource.setProperties(properties);
    }
}

