/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xwiki.task.TaskConfiguration;
import com.xwiki.task.internal.TaskXDOMProcessor;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.job.JobExecutor;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.BeginFoldEvent;
import org.xwiki.observation.event.Event;

public abstract class AbstractTaskEventListener
extends AbstractEventListener {
    public static final String TASK_MANAGER_SPACE = "TaskManager";
    public static final LocalDocumentReference TASK_CLASS_REFERENCE = new LocalDocumentReference(Collections.singletonList("TaskManager"), "TaskManagerClass");
    protected static final String TASK_UPDATE_FLAG = "taskUpdating";
    @Inject
    protected DocumentReferenceResolver<String> resolver;
    @Inject
    protected TaskXDOMProcessor taskXDOMProcessor;
    @Inject
    protected Logger logger;
    @Inject
    protected JobExecutor executor;
    @Inject
    private ObservationContext observationContext;
    @Inject
    private TaskConfiguration configuration;

    public AbstractTaskEventListener(String name, List<? extends Event> events) {
        super(name, events);
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiContext context = (XWikiContext)data;
        XWikiDocument document = (XWikiDocument)source;
        if (this.observationContext.isIn(otherEvent -> this.configuration.getNotSkippedFoldEvents().contains(otherEvent.getClass().getName()))) {
            this.processEvent(document, context, event, true);
            return;
        }
        if (this.observationContext.isIn(otherEvent -> otherEvent instanceof BeginFoldEvent)) {
            return;
        }
        this.processEvent(document, context, event, false);
    }

    protected abstract void processEvent(XWikiDocument var1, XWikiContext var2, Event var3, boolean var4);
}

