/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.task.script;

import com.xwiki.task.TaskConfiguration;
import com.xwiki.task.TaskException;
import com.xwiki.task.TaskMissingDataManager;
import com.xwiki.task.job.TaskDataInferringJobRequest;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.stability.Unstable;

@Component
@Named(value="task")
@Singleton
@Unstable
public class TaskScriptService
implements ScriptService {
    @Inject
    private TaskConfiguration configuration;
    @Inject
    private TaskMissingDataManager taskMissingDataManager;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private JobExecutor jobExecutor;

    public TaskConfiguration getConfiguration() {
        return this.configuration;
    }

    public Job inferTaskData() {
        if (!this.authorization.hasAccess(Right.ADMIN)) {
            return null;
        }
        TaskDataInferringJobRequest jobRequest = new TaskDataInferringJobRequest(new WikiReference("xwiki"));
        try {
            return this.jobExecutor.execute("taskmanager.infertaskdata", (Request)jobRequest);
        }
        catch (JobException jobException) {
            return null;
        }
    }

    public void inferTaskData(DocumentReference documentReference) {
        if (!this.authorization.hasAccess(Right.ADMIN)) {
            return;
        }
        try {
            this.taskMissingDataManager.inferMissingTaskData(documentReference);
        }
        catch (TaskException taskException) {
            // empty catch block
        }
    }

    public List<DocumentReference> getPagesWithIncompleteTaskMacros() {
        try {
            return this.taskMissingDataManager.getMissingDataTaskOwners();
        }
        catch (TaskException e) {
            return Collections.emptyList();
        }
    }
}

