/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.test.openproject;

import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.administration.test.po.AdministrationSectionPage;
import org.xwiki.livedata.test.po.LiveDataElement;
import org.xwiki.livedata.test.po.TableLayoutElement;
import org.xwiki.test.ui.po.ViewPage;

public class OpenProjectAdminPage
extends AdministrationSectionPage {
    @FindBy(id="create-connection-button")
    private WebElement addNewConnectionBtn;
    @FindBy(id="open-project-sync-colors")
    private WebElement syncColorsBtn;
    private static final String SECTION_ID = "OpenProject";

    public OpenProjectAdminPage() {
        super(SECTION_ID);
    }

    public static OpenProjectAdminPage gotoPage() {
        AdministrationSectionPage.gotoPage((String)SECTION_ID);
        return new OpenProjectAdminPage();
    }

    public void addNewConnection(String name, String clientUrl, String clientID, String clientSecret) {
        this.addNewConnectionBtn.click();
        this.fillAndSendConnectionModal(name, clientUrl, clientID, clientSecret);
    }

    public void updateConnection(int index, String name, String clientUrl, String clientID, String clientSecret) {
        TableLayoutElement ld = this.getConnectionsLivedata().getTableLayout();
        ld.clickAction(index, "edit-connection");
        this.fillAndSendConnectionModal(name, clientUrl, clientID, clientSecret);
    }

    public ViewPage triggerColorSyncJob() {
        this.getDriver().findElement(By.id((String)"open-project-sync-colors")).click();
        return new ViewPage();
    }

    public void deleteConnection(int index) {
        TableLayoutElement ld = this.getConnectionsLivedata().getTableLayout();
        ld.clickAction(index, "delete-connection");
        this.getDriver().waitUntilElementIsVisible(By.id((String)"deleteConnectionModal"));
        WebElement modal = this.getDriver().findElement(By.id((String)"deleteConnectionModal"));
        modal.findElement(By.className((String)"btn-danger")).click();
    }

    public LiveDataElement getConnectionsLivedata() {
        return new LiveDataElement("openproject_connections");
    }

    public ViewPage triggerStyleSync() {
        this.syncColorsBtn.click();
        return new ViewPage();
    }

    private void fillAndSendConnectionModal(String name, String clientUrl, String clientID, String clientSecret) {
        this.getDriver().waitUntilElementIsVisible(By.id((String)"handleConnectionModal"));
        WebElement modal = this.getDriver().findElement(By.id((String)"handleConnectionModal"));
        WebElement elem = modal.findElement(By.id((String)"connection-name"));
        elem.clear();
        elem.sendKeys(new CharSequence[]{name});
        elem = modal.findElement(By.id((String)"server-url"));
        elem.clear();
        elem.sendKeys(new CharSequence[]{clientUrl});
        elem = modal.findElement(By.id((String)"client-id"));
        elem.clear();
        elem.sendKeys(new CharSequence[]{clientID});
        elem = modal.findElement(By.id((String)"client-secret"));
        elem.clear();
        elem.sendKeys(new CharSequence[]{clientSecret});
        modal.findElement(By.className((String)"btn-primary")).click();
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

