/*
 * Decompiled with CFR 0.152.
 */
package com.xwiki.projectmanagement.test.openproject;

import com.xwiki.projectmanagement.test.openproject.FilterBuilderFilter;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;
import org.xwiki.test.ui.po.BaseElement;

public class FilterBuilderParameter
extends BaseElement {
    public WebElement getContainer() {
        return this.getDriver().findElement(By.className((String)"proj-manag-constraint-builder"));
    }

    public FilterBuilderFilter addFilter(String filterProperty) {
        Select select = new Select(this.getDriver().findElement(By.id((String)"proj-manag-add-constraint")));
        try {
            select.selectByValue(filterProperty);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        List presentFilters = this.getDriver().findElements(By.xpath((String)"//*[contains(@class, 'proj-manag-constraint-name')]"));
        WebElement createdFilter = null;
        for (WebElement presentFilter : presentFilters) {
            if (!presentFilter.getAttribute("value").equals(filterProperty)) continue;
            createdFilter = presentFilter.findElement(By.xpath((String)"ancestor::div[@class='proj-manag-constraint']"));
            break;
        }
        if (createdFilter == null) {
            throw new NoSuchElementException("Could not find the added filter.");
        }
        return new FilterBuilderFilter(createdFilter);
    }

    public List<FilterBuilderFilter> getFilters() {
        return this.getContainer().findElements(By.cssSelector((String)".proj-manag-constraints .proj-manag-constraint")).stream().map(FilterBuilderFilter::new).collect(Collectors.toList());
    }

    public void clearFilters() {
        try {
            this.getDriver().findElements(By.className((String)"proj-manag-delete-filter")).forEach(WebElement::click);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            // empty catch block
        }
    }
}

